/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.ukulib.utils;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
    }

    public static <T extends Serializable> T newInstance(Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getConstructor(new Class[0]);
            return (T)((Serializable)constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException e) {
            log.error("{} does not have a public no-arg constructor!", (Object)klass.getName());
            throw new NoSuchElementException(e);
        }
        catch (Exception e) {
            log.error("Could not instantiate class {}", (Object)klass.getName());
            throw new IllegalArgumentException(e);
        }
    }
}

