/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.ukulib.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_429;
import net.minecraft.class_437;
import net.uku3lig.ukulib.api.UkulibAPI;
import net.uku3lig.ukulib.config.impl.ModListScreen;
import net.uku3lig.ukulib.config.impl.UkulibConfig;
import net.uku3lig.ukulib.utils.IconButton;
import net.uku3lig.ukulib.utils.Ukutils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_429.class})
public class MixinOptionsScreen
extends class_437 {
    private static final Logger log = LoggerFactory.getLogger(MixinOptionsScreen.class);
    @Unique
    private static final class_2960 DEFAULT_ICON = new class_2960("ukulib", "uku.png");
    @Unique
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    @Unique
    private IconButton ukulibButton;

    @Inject(method={"init"}, at={@At(value="RETURN")})
    public void addUkulibButton(CallbackInfo ci) {
        if (FabricLoader.getInstance().getEntrypointContainers("ukulib", UkulibAPI.class).isEmpty()) {
            return;
        }
        if (!UkulibConfig.get().isButtonInOptions()) {
            return;
        }
        String username = UkulibConfig.get().getHeadName();
        class_2960 texture = DEFAULT_ICON;
        class_2960 customHeadTex = Ukutils.getHeadTex(username);
        if (Ukutils.textureExists(customHeadTex)) {
            texture = customHeadTex;
        } else {
            MixinOptionsScreen.registerHeadTex(username).thenRun(() -> this.ukulibButton.setTexture(customHeadTex));
        }
        this.ukulibButton = (IconButton)this.method_37063((class_364)new IconButton(this.field_22789 / 2 + 158, this.field_22790 / 6 + 144 - 6, 20, 20, texture, 16, 16, button -> class_310.method_1551().method_1507((class_437)new ModListScreen(this))));
    }

    @Unique
    private static CompletableFuture<Void> registerHeadTex(String username) {
        class_2960 identifier = Ukutils.getHeadTex(username);
        if (Ukutils.textureExists(identifier)) {
            return CompletableFuture.completedFuture(null);
        }
        class_1060 texManager = class_310.method_1551().method_1531();
        HttpRequest req = HttpRequest.newBuilder(URI.create("https://mc-heads.net/avatar/" + username + "/16.png")).GET().build();
        return HTTP_CLIENT.sendAsync(req, HttpResponse.BodyHandlers.ofByteArray()).thenAccept(r -> {
            if (r.statusCode() == 200) {
                try {
                    class_1011 image = class_1011.method_49277((byte[])((byte[])r.body()));
                    RenderSystem.recordRenderCall(() -> texManager.method_4616(identifier, (class_1044)new class_1043(image)));
                }
                catch (IOException e) {
                    log.error("Failed to register head texture", (Throwable)e);
                }
            } else {
                log.error("Could not fetch head texture: {} {}", (Object)r.statusCode(), (Object)new String((byte[])r.body()));
            }
        });
    }

    protected MixinOptionsScreen(class_2561 title) {
        super(title);
    }
}

