/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.ukulib.config.serialization;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import net.uku3lig.ukulib.config.serialization.ConfigSerializer;
import net.uku3lig.ukulib.utils.ReflectionUtils;
import net.uku3lig.ukulib.utils.Ukutils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomlConfigSerializer<T extends Serializable>
implements ConfigSerializer<T> {
    private static final Logger log = LoggerFactory.getLogger(TomlConfigSerializer.class);
    private final Class<T> configClass;
    private final File file;

    public TomlConfigSerializer(Class<T> configClass, String name) {
        this.configClass = configClass;
        this.file = Ukutils.getConfigPath(name + ".toml").toFile();
    }

    @Override
    public T deserialize() {
        if (!Files.isRegularFile(this.file.toPath(), new LinkOption[0])) {
            File parent = this.file.getParentFile();
            T defaultConfig = this.makeDefault();
            if (!parent.mkdirs() && !Files.isDirectory(parent.toPath(), new LinkOption[0])) {
                log.warn("Could not create directory {}", (Object)parent.getAbsolutePath());
            } else {
                this.serialize(defaultConfig);
            }
            return defaultConfig;
        }
        try {
            return (T)((Serializable)new Toml().read(this.file).to(this.configClass));
        }
        catch (Exception e) {
            log.warn("A corrupted configuration file was found, overwriting it with the default config", (Throwable)e);
            T defaultConfig = this.makeDefault();
            this.serialize(defaultConfig);
            return defaultConfig;
        }
    }

    @Override
    public void serialize(T config) {
        try {
            new TomlWriter().write(config, this.file);
        }
        catch (IOException e) {
            log.warn("Could not write config", (Throwable)e);
        }
    }

    @Override
    public T makeDefault() {
        return ReflectionUtils.newInstance(this.configClass);
    }
}

