/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.ukulib.config.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.uku3lig.ukulib.config.serialization.ConfigSerializer;
import net.uku3lig.ukulib.utils.ReflectionUtils;
import net.uku3lig.ukulib.utils.Ukutils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfigSerializer<T extends Serializable>
implements ConfigSerializer<T> {
    private static final Logger log = LoggerFactory.getLogger(JsonConfigSerializer.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Class<T> configClass;
    private final Path path;

    public JsonConfigSerializer(Class<T> configClass, String name) {
        this.configClass = configClass;
        this.path = Ukutils.getConfigPath(name + ".json");
    }

    @Override
    public T deserialize() {
        if (!Files.isRegularFile(this.path, new LinkOption[0])) {
            Path parent = this.path.getParent();
            T defaultConfig = this.makeDefault();
            if (!parent.toFile().mkdirs() && !Files.isDirectory(parent, new LinkOption[0])) {
                log.warn("Could not create directory {}", (Object)parent.toAbsolutePath());
            } else {
                this.serialize(defaultConfig);
            }
            return defaultConfig;
        }
        try {
            return (T)((Serializable)GSON.fromJson((Reader)Files.newBufferedReader(this.path), this.configClass));
        }
        catch (Exception e) {
            log.warn("A corrupted configuration file was found, overwriting it with the default config", (Throwable)e);
            T defaultConfig = this.makeDefault();
            this.serialize(defaultConfig);
            return defaultConfig;
        }
    }

    @Override
    public void serialize(T config) {
        try {
            GSON.toJson(config, (Appendable)Files.newBufferedWriter(this.path, new OpenOption[0]));
        }
        catch (Exception e) {
            log.warn("Could not write config to file", (Throwable)e);
        }
    }

    @Override
    public T makeDefault() {
        return ReflectionUtils.newInstance(this.configClass);
    }
}

