/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.ukulib.config.option.widget;

import java.util.Optional;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import net.minecraft.class_332;
import net.uku3lig.ukulib.config.option.widget.TextInputWidget;

public class ColorInputWidget
extends TextInputWidget {
    private static final Predicate<String> IS_COLOR = s -> s.matches("^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{8})$");
    private final boolean allowAlpha;

    public ColorInputWidget(int x, int y, int width, int height, int initialValue, IntConsumer changedListener, String suggestion, boolean allowAlpha) {
        super(x, y, width - height - 2, height, "#" + Integer.toHexString(initialValue).toUpperCase(), s -> ColorInputWidget.convert(s, allowAlpha).ifPresent(changedListener::accept), suggestion, IS_COLOR, 9);
        this.allowAlpha = allowAlpha;
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_48579(drawContext, mouseX, mouseY, delta);
        if (!this.isVisible()) {
            return;
        }
        ColorInputWidget.convert(this.getText(), this.allowAlpha).ifPresent(color -> {
            int x = this.method_46426() + this.field_22758 + 2;
            int y = this.method_46427();
            int size = this.field_22759;
            if (color <= 0xFFFFFF && !this.allowAlpha) {
                color = color | 0xFF000000;
            }
            drawContext.method_25294(x, y, x + size, y + size, color.intValue());
        });
    }

    private static Optional<Integer> convert(String value, boolean allowAlpha) {
        if (!IS_COLOR.test(value)) {
            return Optional.empty();
        }
        try {
            value = value.replace("#", "");
            if (value.length() == 6 || allowAlpha && value.length() == 8) {
                int color = Integer.parseUnsignedInt(value, 16);
                if (color <= 0xFFFFFF && !allowAlpha) {
                    color |= 0xFF000000;
                }
                return Optional.of(color);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }
}

