/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.ukulib.config;

import java.io.Serializable;
import net.uku3lig.ukulib.config.ConfigManagerReloader;
import net.uku3lig.ukulib.config.serialization.ConfigSerializer;
import net.uku3lig.ukulib.config.serialization.TomlConfigSerializer;

public class ConfigManager<T extends Serializable> {
    private final ConfigSerializer<T> serializer;
    private T config;

    public ConfigManager(ConfigSerializer<T> serializer, T config) {
        this.serializer = serializer;
        this.config = config;
        ConfigManagerReloader.addManager(this);
    }

    public ConfigManager(ConfigSerializer<T> serializer) {
        this(serializer, serializer.deserialize());
    }

    public static <T extends Serializable> ConfigManager<T> createDefault(Class<T> configClass, String name) {
        return new ConfigManager<T>(new TomlConfigSerializer<T>(configClass, name));
    }

    public void saveConfig() {
        this.serializer.serialize(this.config);
    }

    public void replaceConfig(T newConfig) {
        this.config = newConfig;
        this.serializer.serialize(newConfig);
    }

    public void resetConfig() {
        this.replaceConfig(this.serializer.makeDefault());
    }

    ConfigSerializer<T> getSerializer() {
        return this.serializer;
    }

    public T getConfig() {
        return this.config;
    }
}

