/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.io.IOUtils;
import team.creative.ambientsounds.AmbientCondition;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientRegion;
import team.creative.ambientsounds.AmbientSelection;
import team.creative.ambientsounds.AmbientVolume;
import team.creative.ambientsounds.env.AmbientEnvironment;
import team.creative.creativecore.common.config.api.CreativeConfig;

public class AmbientDimension {
    @CreativeConfig.DecimalRange(min=0.0, max=1.0)
    public transient double volumeSetting = 1.0;
    public transient HashMap<String, AmbientRegion> regions;
    public transient HashMap<String, AmbientCondition> biomeTypeSelectors = new HashMap();
    public String name;
    public boolean mute = false;
    @SerializedName(value="biome-selector")
    public AmbientCondition biomeSelector;
    public Boolean night;
    public Boolean rain;
    public Boolean storm;
    @SerializedName(value="dimension-names")
    public String[] dimensionNames;
    @SerializedName(value="bad-dimension-names")
    public String[] badDimensionNames;
    @SerializedName(value="average-height")
    public Integer averageHeight;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(AmbientEngine engine, Gson gson, class_3300 manager, JsonObject object) throws IOException {
        this.regions = new HashMap();
        for (class_3298 resource : manager.method_14489(new class_2960("ambientsounds", engine.name + "/dimension_regions/" + this.name + ".json"))) {
            try (InputStream input = resource.method_14482();){
                AmbientRegion[] regions = (AmbientRegion[])gson.fromJson(JsonParser.parseString((String)IOUtils.toString((InputStream)input, (Charset)Charsets.UTF_8)), AmbientRegion[].class);
                for (int j = 0; j < regions.length; ++j) {
                    AmbientRegion region = regions[j];
                    region.dimension = this;
                    this.regions.put(region.name, region);
                    region.load(engine, gson, manager);
                }
            }
        }
        for (String type : engine.biomeTypes) {
            JsonElement element = object.get(type + "-selector");
            if (element == null) continue;
            this.biomeTypeSelectors.put(type, (AmbientCondition)gson.fromJson(element, AmbientCondition.class));
        }
    }

    public void init(AmbientEngine engine) {
        if (this.biomeSelector != null) {
            this.biomeSelector.init(engine);
        }
        for (AmbientCondition condition : this.biomeTypeSelectors.values()) {
            condition.init(engine);
        }
        if (this.badDimensionNames != null) {
            for (int i = 0; i < this.badDimensionNames.length; ++i) {
                this.badDimensionNames[i] = ".*" + this.badDimensionNames[i].toLowerCase().replace("*", ".*").replace("?", "\\?") + ".*";
            }
        }
        if (this.dimensionNames != null) {
            for (int i = 0; i < this.dimensionNames.length; ++i) {
                this.dimensionNames[i] = ".*" + this.dimensionNames[i].toLowerCase().replace("*", ".*").replace("?", "\\?") + ".*";
            }
        }
    }

    public boolean is(class_1937 level) {
        int j;
        String dimensionTypeName = level.method_27983().method_29177().toString();
        if (this.badDimensionNames != null) {
            for (j = 0; j < this.badDimensionNames.length; ++j) {
                if (!dimensionTypeName.matches(this.badDimensionNames[j])) continue;
                return false;
            }
        }
        if (this.dimensionNames != null) {
            for (j = 0; j < this.dimensionNames.length; ++j) {
                if (!dimensionTypeName.matches(this.dimensionNames[j])) continue;
                return true;
            }
        }
        return this.dimensionNames == null;
    }

    public void manipulateEnviroment(AmbientEnvironment env) {
        env.muted = this.mute;
        if (this.night != null) {
            env.night = this.night;
        }
        if (this.rain != null) {
            env.raining = this.rain;
        }
        if (this.storm != null) {
            env.thundering = this.storm;
        }
        if (this.biomeSelector != null) {
            AmbientSelection selection = this.biomeSelector.value(env);
            env.biomeVolume = selection != null ? selection : AmbientVolume.SILENT;
        }
        env.biomeTypeVolumes.clear();
        for (Map.Entry<String, AmbientCondition> entry : this.biomeTypeSelectors.entrySet()) {
            AmbientSelection selection = entry.getValue().value(env);
            if (selection != null) {
                env.biomeTypeVolumes.put(entry.getKey(), selection);
                continue;
            }
            env.biomeTypeVolumes.put(entry.getKey(), AmbientVolume.SILENT);
        }
    }

    public String toString() {
        return this.name;
    }
}

