/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.fabric.impl.client;

import fuzs.forgeconfigapiport.fabric.impl.client.commands.ConfigCommand;
import fuzs.forgeconfigapiport.fabric.impl.network.client.config.ConfigSyncClient;
import fuzs.forgeconfigapiport.fabric.impl.network.config.ConfigSync;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.minecraft.class_2960;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfig;

public class ForgeConfigAPIPortFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ForgeConfigAPIPortFabricClient.registerMessages();
        ForgeConfigAPIPortFabricClient.registerHandlers();
    }

    private static void registerMessages() {
        ClientLoginNetworking.registerGlobalReceiver((class_2960)ConfigSync.SYNC_CONFIGS_CHANNEL, (client1, handler1, buf1, listenerAdder1) -> ConfigSyncClient.onSyncConfigs(client1, handler1, buf1));
        ClientLoginNetworking.registerGlobalReceiver((class_2960)ConfigSync.ESTABLISH_MODDED_CONNECTION_CHANNEL, (client, handler, buf, listenerAdder) -> ConfigSyncClient.onEstablishModdedConnection(client, handler, buf));
    }

    private static void registerHandlers() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            ConfigCommand.register(new ConfigCommand.ConfigCommandContext<ModConfig.Type>(){

                @Override
                public String name() {
                    return "forgeconfig";
                }

                @Override
                public Class<ModConfig.Type> getType() {
                    return ModConfig.Type.class;
                }

                @Override
                public List<String> getConfigFileNames(String modId, ModConfig.Type type) {
                    return ConfigTracker.INSTANCE.getConfigFileNames(modId, type);
                }
            }, dispatcher, FabricClientCommandSource::sendFeedback);
            ConfigCommand.register(new ConfigCommand.ConfigCommandContext<ModConfig.Type>(){

                @Override
                public String name() {
                    return "neoforgeconfig";
                }

                @Override
                public Class<ModConfig.Type> getType() {
                    return ModConfig.Type.class;
                }

                @Override
                public List<String> getConfigFileNames(String modId, ModConfig.Type type) {
                    return net.neoforged.fml.config.ConfigTracker.INSTANCE.getConfigFileNames(modId, type);
                }
            }, dispatcher, FabricClientCommandSource::sendFeedback);
        });
    }
}

