/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.linbus.stream.impl;

import org.enginehub.linbus.stream.exception.NbtParseException;
import org.enginehub.linbus.stream.token.LinToken;

public class ValueCounter {
    private static final byte BYTE_ARRAY = 1;
    private static final byte INT_ARRAY = 2;
    private static final byte LONG_ARRAY = 3;
    private int count;
    private int compounds;
    private int lists;
    private byte arrayType;

    public void add(LinToken token) {
        if (token.isSimpleValue() && !this.isNested()) {
            ++this.count;
            return;
        }
        if (token instanceof LinToken.CompoundStart) {
            ++this.compounds;
        } else if (token instanceof LinToken.CompoundEnd) {
            --this.compounds;
            if (this.compounds < 0) {
                throw new NbtParseException("Compound end without start");
            }
            if (!this.isNested()) {
                ++this.count;
            }
        } else if (token instanceof LinToken.ListStart) {
            ++this.lists;
        } else if (token instanceof LinToken.ListEnd) {
            --this.lists;
            if (this.lists < 0) {
                throw new NbtParseException("List end without start");
            }
            if (!this.isNested()) {
                ++this.count;
            }
        } else if (token instanceof LinToken.ByteArrayStart) {
            this.arrayType = 1;
        } else if (token instanceof LinToken.ByteArrayEnd) {
            if (this.arrayType != 1) {
                throw new NbtParseException("Byte array end without start");
            }
            this.arrayType = 0;
            if (!this.isNested()) {
                ++this.count;
            }
        } else if (token instanceof LinToken.IntArrayStart) {
            this.arrayType = (byte)2;
        } else if (token instanceof LinToken.IntArrayEnd) {
            if (this.arrayType != 2) {
                throw new NbtParseException("Int array end without start");
            }
            this.arrayType = 0;
            if (!this.isNested()) {
                ++this.count;
            }
        } else if (token instanceof LinToken.LongArrayStart) {
            this.arrayType = (byte)3;
        } else if (token instanceof LinToken.LongArrayEnd) {
            if (this.arrayType != 3) {
                throw new NbtParseException("Long array end without start");
            }
            this.arrayType = 0;
            if (!this.isNested()) {
                ++this.count;
            }
        }
    }

    public int count() {
        return this.count;
    }

    public boolean isNested() {
        return this.lists > 0 || this.compounds > 0;
    }
}

