/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.linbus.stream.impl;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.enginehub.linbus.common.LinTagId;
import org.enginehub.linbus.stream.LinStream;
import org.enginehub.linbus.stream.exception.NbtParseException;
import org.enginehub.linbus.stream.impl.ValueCounter;
import org.enginehub.linbus.stream.token.LinToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalInfoCalculator
implements LinStream {
    private final LinStream original;
    private Deque<LinToken> tokenBuffer;

    public OptionalInfoCalculator(LinStream original) {
        this.original = original;
    }

    @Override
    @Nullable
    public LinToken nextOrNull() throws IOException {
        LinToken next;
        if (this.tokenBuffer != null) {
            next = this.tokenBuffer.pollFirst();
            if (next != null) {
                return next;
            }
            this.tokenBuffer = null;
        }
        if ((next = this.original.nextOrNull()) == null) {
            return null;
        }
        TokenAndBuffer tokenAndBuffer = this.fillIfNeeded(next);
        if (tokenAndBuffer.buffer != null && !tokenAndBuffer.buffer.isEmpty()) {
            this.tokenBuffer = tokenAndBuffer.buffer;
        }
        return tokenAndBuffer.token;
    }

    @Override
    public LinStream calculateOptionalInfo() {
        return this;
    }

    private TokenAndBuffer fillIfNeeded(LinToken token) throws IOException {
        LinToken.Name name;
        LinToken.LongArrayStart longArrayStart;
        LinToken.ListStart listStart;
        if (token instanceof LinToken.ListStart && ((listStart = (LinToken.ListStart)token).size().isEmpty() || listStart.elementId().isEmpty())) {
            return this.getFilled(new ListStartFill(listStart));
        }
        if (token instanceof LinToken.ByteArrayStart) {
            LinToken.ByteArrayStart byteArrayStart = (LinToken.ByteArrayStart)token;
            if (byteArrayStart.size().isPresent()) {
                return new TokenAndBuffer(token, null);
            }
            return this.getFilled(new ByteArrayStartFill());
        }
        if (token instanceof LinToken.IntArrayStart) {
            LinToken.IntArrayStart intArrayStart = (LinToken.IntArrayStart)token;
            if (intArrayStart.size().isPresent()) {
                return new TokenAndBuffer(token, null);
            }
            return this.getFilled(new IntArrayStartFill());
        }
        if (token instanceof LinToken.LongArrayStart && (longArrayStart = (LinToken.LongArrayStart)token).size().isEmpty()) {
            return this.getFilled(new LongArrayStartFill());
        }
        if (token instanceof LinToken.Name && (name = (LinToken.Name)token).id().isEmpty()) {
            return this.getFilled(new NameFill(name.name()));
        }
        return new TokenAndBuffer(token, null);
    }

    private TokenAndBuffer getFilled(OptionalFill fill) throws IOException {
        LinToken filled;
        ArrayDeque<LinToken> buffer = new ArrayDeque<LinToken>();
        ArrayDeque<LinToken> consumedTokenStack = new ArrayDeque<LinToken>();
        while (true) {
            LinToken next;
            if ((next = (LinToken)buffer.pollFirst()) == null) {
                LinToken originalNext = this.original.nextOrNull();
                if (originalNext == null) {
                    throw new NbtParseException("Optional value not filled by the end of token stream");
                }
                TokenAndBuffer tokenAndBuffer = this.fillIfNeeded(originalNext);
                buffer.add(tokenAndBuffer.token);
                consumedTokenStack.add(tokenAndBuffer.token);
                if (tokenAndBuffer.buffer == null) continue;
                buffer.addAll(tokenAndBuffer.buffer);
                consumedTokenStack.addAll(tokenAndBuffer.buffer);
                continue;
            }
            filled = fill.tryFill(next);
            if (filled != null) break;
        }
        return new TokenAndBuffer(filled, consumedTokenStack);
    }

    private record TokenAndBuffer(@NotNull LinToken token, @Nullable Deque<LinToken> buffer) {
    }

    private static final class ListStartFill
    implements OptionalFill {
        private final int knownSize;
        private final ValueCounter counter;
        private LinTagId elementId;

        public ListStartFill(LinToken.ListStart listStart) {
            if (listStart.size().isPresent()) {
                this.knownSize = listStart.size().getAsInt();
                this.counter = null;
            } else {
                this.knownSize = -1;
                this.counter = new ValueCounter();
            }
            this.elementId = listStart.elementId().orElse(null);
        }

        @Override
        @Nullable
        public LinToken tryFill(LinToken token) {
            if (this.counter == null || !this.counter.isNested()) {
                LinTagId elementId = this.elementId;
                if (elementId == null) {
                    elementId = token instanceof LinToken.ListEnd ? LinTagId.END : token.tagId().orElseThrow(() -> new NbtParseException("Token doesn't represent a tag directly: " + token));
                    this.elementId = elementId;
                }
                if (this.counter == null) {
                    return new LinToken.ListStart(this.knownSize, elementId);
                }
                if (token instanceof LinToken.ListEnd) {
                    return new LinToken.ListStart(this.counter.count(), elementId);
                }
            }
            this.counter.add(token);
            return null;
        }
    }

    private static interface OptionalFill {
        @Nullable
        public LinToken tryFill(LinToken var1);
    }

    private static final class ByteArrayStartFill
    implements OptionalFill {
        private int size;

        private ByteArrayStartFill() {
        }

        @Override
        @Nullable
        public LinToken tryFill(LinToken token) {
            if (token instanceof LinToken.ByteArrayEnd) {
                return new LinToken.ByteArrayStart(this.size);
            }
            if (token instanceof LinToken.ByteArrayContent) {
                LinToken.ByteArrayContent content = (LinToken.ByteArrayContent)token;
                this.size += content.buffer().remaining();
            } else {
                throw new NbtParseException("Unexpected token: " + token);
            }
            return null;
        }
    }

    private static final class IntArrayStartFill
    implements OptionalFill {
        private int size;

        private IntArrayStartFill() {
        }

        @Override
        @Nullable
        public LinToken tryFill(LinToken token) {
            if (token instanceof LinToken.IntArrayEnd) {
                return new LinToken.IntArrayStart(this.size);
            }
            if (token instanceof LinToken.IntArrayContent) {
                LinToken.IntArrayContent content = (LinToken.IntArrayContent)token;
                this.size += content.buffer().remaining();
            } else {
                throw new NbtParseException("Unexpected token: " + token);
            }
            return null;
        }
    }

    private static final class LongArrayStartFill
    implements OptionalFill {
        private int size;

        private LongArrayStartFill() {
        }

        @Override
        @Nullable
        public LinToken tryFill(LinToken token) {
            if (token instanceof LinToken.LongArrayEnd) {
                return new LinToken.LongArrayStart(this.size);
            }
            if (token instanceof LinToken.LongArrayContent) {
                LinToken.LongArrayContent content = (LinToken.LongArrayContent)token;
                this.size += content.buffer().remaining();
            } else {
                throw new NbtParseException("Unexpected token: " + token);
            }
            return null;
        }
    }

    private record NameFill(String name) implements OptionalFill
    {
        @Override
        public LinToken tryFill(LinToken token) {
            return new LinToken.Name(this.name, token.tagId().orElseThrow(() -> new NbtParseException("Token doesn't represent a tag directly: " + token)));
        }
    }
}

