/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.enginehub.linbus.common.LinTagId;
import org.enginehub.linbus.tree.LinByteArrayTag;
import org.enginehub.linbus.tree.LinByteTag;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinDoubleTag;
import org.enginehub.linbus.tree.LinEndTag;
import org.enginehub.linbus.tree.LinFloatTag;
import org.enginehub.linbus.tree.LinIntArrayTag;
import org.enginehub.linbus.tree.LinIntTag;
import org.enginehub.linbus.tree.LinListTag;
import org.enginehub.linbus.tree.LinLongArrayTag;
import org.enginehub.linbus.tree.LinLongTag;
import org.enginehub.linbus.tree.LinShortTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;

public final class NBTConverter {
    private NBTConverter() {
    }

    public static Tag toNative(LinTag<?> tag) {
        if (tag instanceof LinIntArrayTag) {
            LinIntArrayTag t = (LinIntArrayTag)tag;
            return NBTConverter.toNative(t);
        }
        if (tag instanceof LinListTag) {
            LinListTag t = (LinListTag)tag;
            return NBTConverter.toNative(t);
        }
        if (tag instanceof LinLongTag) {
            LinLongTag t = (LinLongTag)tag;
            return NBTConverter.toNative(t);
        }
        if (tag instanceof LinLongArrayTag) {
            LinLongArrayTag t = (LinLongArrayTag)tag;
            return NBTConverter.toNative(t);
        }
        if (tag instanceof LinStringTag) {
            LinStringTag t = (LinStringTag)tag;
            return NBTConverter.toNative(t);
        }
        if (tag instanceof LinIntTag) {
            LinIntTag t = (LinIntTag)tag;
            return NBTConverter.toNative(t);
        }
        if (tag instanceof LinByteTag) {
            LinByteTag t = (LinByteTag)tag;
            return NBTConverter.toNative(t);
        }
        if (tag instanceof LinByteArrayTag) {
            LinByteArrayTag t = (LinByteArrayTag)tag;
            return NBTConverter.toNative(t);
        }
        if (tag instanceof LinCompoundTag) {
            LinCompoundTag t = (LinCompoundTag)tag;
            return NBTConverter.toNative(t);
        }
        if (tag instanceof LinFloatTag) {
            LinFloatTag t = (LinFloatTag)tag;
            return NBTConverter.toNative(t);
        }
        if (tag instanceof LinShortTag) {
            LinShortTag t = (LinShortTag)tag;
            return NBTConverter.toNative(t);
        }
        if (tag instanceof LinDoubleTag) {
            LinDoubleTag t = (LinDoubleTag)tag;
            return NBTConverter.toNative(t);
        }
        throw new IllegalArgumentException("Can't convert tag of type " + tag.getClass().getCanonicalName());
    }

    public static IntArrayTag toNative(LinIntArrayTag tag) {
        int[] value = tag.value();
        return new IntArrayTag(Arrays.copyOf(value, value.length));
    }

    public static ListTag toNative(LinListTag<?> tag) {
        ListTag list = new ListTag();
        Iterator iterator = tag.value().iterator();
        while (iterator.hasNext()) {
            LinTag child = (LinTag)iterator.next();
            list.add((Object)NBTConverter.toNative(child));
        }
        return list;
    }

    public static LongTag toNative(LinLongTag tag) {
        return LongTag.m_128882_((long)tag.value());
    }

    public static LongArrayTag toNative(LinLongArrayTag tag) {
        return new LongArrayTag((long[])tag.value().clone());
    }

    public static StringTag toNative(LinStringTag tag) {
        return StringTag.m_129297_((String)tag.value());
    }

    public static IntTag toNative(LinIntTag tag) {
        return IntTag.m_128679_((int)tag.value());
    }

    public static ByteTag toNative(LinByteTag tag) {
        return ByteTag.m_128266_((byte)tag.value());
    }

    public static ByteArrayTag toNative(LinByteArrayTag tag) {
        return new ByteArrayTag((byte[])tag.value().clone());
    }

    public static CompoundTag toNative(LinCompoundTag tag) {
        CompoundTag compound = new CompoundTag();
        tag.value().forEach((key, value) -> compound.m_128365_(key, NBTConverter.toNative(value)));
        return compound;
    }

    public static FloatTag toNative(LinFloatTag tag) {
        return FloatTag.m_128566_((float)tag.value().floatValue());
    }

    public static ShortTag toNative(LinShortTag tag) {
        return ShortTag.m_129258_((short)tag.value());
    }

    public static DoubleTag toNative(LinDoubleTag tag) {
        return DoubleTag.m_128500_((double)tag.value());
    }

    public static LinTag<?> fromNative(Tag other) {
        if (other instanceof IntArrayTag) {
            return NBTConverter.fromNative((IntArrayTag)other);
        }
        if (other instanceof ListTag) {
            return NBTConverter.fromNative((ListTag)other);
        }
        if (other instanceof EndTag) {
            return NBTConverter.fromNative((EndTag)other);
        }
        if (other instanceof LongTag) {
            return NBTConverter.fromNative((LongTag)other);
        }
        if (other instanceof LongArrayTag) {
            return NBTConverter.fromNative((LongArrayTag)other);
        }
        if (other instanceof StringTag) {
            return NBTConverter.fromNative((StringTag)other);
        }
        if (other instanceof IntTag) {
            return NBTConverter.fromNative((IntTag)other);
        }
        if (other instanceof ByteTag) {
            return NBTConverter.fromNative((ByteTag)other);
        }
        if (other instanceof ByteArrayTag) {
            return NBTConverter.fromNative((ByteArrayTag)other);
        }
        if (other instanceof CompoundTag) {
            return NBTConverter.fromNative((CompoundTag)other);
        }
        if (other instanceof FloatTag) {
            return NBTConverter.fromNative((FloatTag)other);
        }
        if (other instanceof ShortTag) {
            return NBTConverter.fromNative((ShortTag)other);
        }
        if (other instanceof DoubleTag) {
            return NBTConverter.fromNative((DoubleTag)other);
        }
        throw new IllegalArgumentException("Can't convert other of type " + other.getClass().getCanonicalName());
    }

    public static LinIntArrayTag fromNative(IntArrayTag other) {
        int[] value = other.m_128648_();
        return LinIntArrayTag.of(Arrays.copyOf(value, value.length));
    }

    public static LinListTag<?> fromNative(ListTag other) {
        LinListTag.Builder<LinTag<?>> list = LinListTag.builder(LinTagType.fromId(LinTagId.fromId(other.m_7264_())));
        for (Tag tag : other) {
            list.add(NBTConverter.fromNative(tag));
        }
        return list.build();
    }

    public static LinEndTag fromNative(EndTag other) {
        return LinEndTag.instance();
    }

    public static LinLongTag fromNative(LongTag other) {
        return LinLongTag.of(other.m_7046_());
    }

    public static LinLongArrayTag fromNative(LongArrayTag other) {
        return LinLongArrayTag.of((long[])other.m_128851_().clone());
    }

    public static LinStringTag fromNative(StringTag other) {
        return LinStringTag.of(other.m_7916_());
    }

    public static LinIntTag fromNative(IntTag other) {
        return LinIntTag.of(other.m_7047_());
    }

    public static LinByteTag fromNative(ByteTag other) {
        return LinByteTag.of(other.m_7063_());
    }

    public static LinByteArrayTag fromNative(ByteArrayTag other) {
        return LinByteArrayTag.of((byte[])other.m_128227_().clone());
    }

    public static LinCompoundTag fromNative(CompoundTag other) {
        Set tags = other.m_128431_();
        LinCompoundTag.Builder builder = LinCompoundTag.builder();
        for (String tagName : tags) {
            builder.put(tagName, NBTConverter.fromNative(other.m_128423_(tagName)));
        }
        return builder.build();
    }

    public static LinFloatTag fromNative(FloatTag other) {
        return LinFloatTag.of(other.m_7057_());
    }

    public static LinShortTag fromNative(ShortTag other) {
        return LinShortTag.of(other.m_7053_());
    }

    public static LinDoubleTag fromNative(DoubleTag other) {
        return LinDoubleTag.of(other.m_7061_());
    }
}

