/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.internal;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.internal.ForgeEntity;
import com.sk89q.worldedit.forge.internal.NBTConverter;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ForgeServerLevelDelegateProxy
implements InvocationHandler {
    private final EditSession editSession;
    private final ServerLevel serverLevel;

    private ForgeServerLevelDelegateProxy(EditSession editSession, ServerLevel serverLevel) {
        this.editSession = editSession;
        this.serverLevel = serverLevel;
    }

    public static WorldGenLevel newInstance(EditSession editSession, ServerLevel serverLevel) {
        return (WorldGenLevel)Proxy.newProxyInstance(serverLevel.getClass().getClassLoader(), serverLevel.getClass().getInterfaces(), (InvocationHandler)new ForgeServerLevelDelegateProxy(editSession, serverLevel));
    }

    @Nullable
    private BlockEntity getBlockEntity(BlockPos blockPos) {
        BlockEntity tileEntity = this.serverLevel.m_46745_(blockPos).m_7702_(blockPos);
        if (tileEntity == null) {
            return null;
        }
        BlockEntity newEntity = tileEntity.m_58903_().m_155264_(blockPos, this.getBlockState(blockPos));
        newEntity.m_142466_(NBTConverter.toNative(this.editSession.getFullBlock(ForgeAdapter.adapt(blockPos)).getNbtReference().getValue()));
        return newEntity;
    }

    private BlockState getBlockState(BlockPos blockPos) {
        return ForgeAdapter.adapt(this.editSession.getBlock(ForgeAdapter.adapt(blockPos)));
    }

    private boolean setBlock(BlockPos blockPos, BlockState blockState) {
        try {
            return this.editSession.setBlock(ForgeAdapter.adapt(blockPos), ForgeAdapter.adapt(blockState));
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean removeBlock(BlockPos blockPos, boolean bl) {
        try {
            return this.editSession.setBlock(ForgeAdapter.adapt(blockPos), BlockTypes.AIR.getDefaultState());
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean addEntity(Entity entity) {
        BaseEntity baseEntity;
        Vector3 pos = ForgeAdapter.adapt(entity.m_20318_(0.0f));
        Location location = new Location((Extent)ForgeAdapter.adapt(this.serverLevel), pos.x(), pos.y(), pos.z());
        return this.editSession.createEntity(location, baseEntity = new ForgeEntity(entity).getState()) != null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "getBlockState": 
            case "m_8055_": {
                Object object;
                if (args.length != 1 || !((object = args[0]) instanceof BlockPos)) break;
                BlockPos blockPos = (BlockPos)object;
                return this.getBlockState(blockPos);
            }
            case "getBlockEntity": 
            case "m_7702_": {
                Object object;
                if (args.length != 1 || !((object = args[0]) instanceof BlockPos)) break;
                BlockPos blockPos = (BlockPos)object;
                return this.getBlockEntity(blockPos);
            }
            case "setBlock": 
            case "m_7731_": {
                Object object;
                if (args.length < 2 || !((object = args[0]) instanceof BlockPos)) break;
                BlockPos blockPos = (BlockPos)object;
                object = args[1];
                if (!(object instanceof BlockState)) break;
                BlockState blockState = (BlockState)object;
                return this.setBlock(blockPos, blockState);
            }
            case "removeBlock": 
            case "destroyBlock": 
            case "m_7471_": 
            case "m_7740_": {
                Object object;
                if (args.length < 2 || !((object = args[0]) instanceof BlockPos)) break;
                BlockPos blockPos = (BlockPos)object;
                object = args[1];
                if (!(object instanceof Boolean)) break;
                Boolean bl = (Boolean)object;
                return this.removeBlock(blockPos, bl);
            }
            case "addEntity": 
            case "m_8872_": 
            case "addFreshEntityWithPassengers": 
            case "m_47205_": {
                Object object;
                if (args.length < 1 || !((object = args[0]) instanceof Entity)) break;
                Entity entity = (Entity)object;
                return this.addEntity(entity);
            }
        }
        return method.invoke((Object)this.serverLevel, args);
    }
}

