/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.forge.ThreadSafeCache;
import com.sk89q.worldedit.forge.internal.NBTConverter;
import com.sk89q.worldedit.forge.net.handler.WECUIPacketHandler;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.WorldEditText;
import com.sk89q.worldedit.util.formatting.component.TextUtils;
import com.sk89q.worldedit.util.formatting.text.serializer.gson.GsonComponentSerializer;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.enginehub.linbus.tree.LinCompoundTag;

public class ForgePlayer
extends AbstractPlayerActor {
    private final ServerPlayer player;

    protected ForgePlayer(ServerPlayer player) {
        this.player = player;
        ThreadSafeCache.getInstance().getOnlineIds().add(this.getUniqueId());
    }

    @Override
    public UUID getUniqueId() {
        return this.player.m_20148_();
    }

    @Override
    public BaseItemStack getItemInHand(HandSide handSide) {
        ItemStack is = this.player.m_21120_(handSide == HandSide.MAIN_HAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        return ForgeAdapter.adapt(is);
    }

    @Override
    public String getName() {
        return this.player.m_7755_().getString();
    }

    @Override
    public BaseEntity getState() {
        throw new UnsupportedOperationException("Cannot create a state from this object");
    }

    @Override
    public Location getLocation() {
        Vector3 position = Vector3.at(this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
        return new Location((Extent)ForgeWorldEdit.inst.getWorld(this.player.m_284548_()), position, this.player.m_146908_(), this.player.m_146909_());
    }

    @Override
    public boolean setLocation(Location location) {
        ServerLevel level = ForgeAdapter.adapt((World)location.getExtent());
        this.player.m_8999_(level, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        return this.player.m_284548_() == level;
    }

    @Override
    public World getWorld() {
        return ForgeWorldEdit.inst.getWorld(this.player.m_284548_());
    }

    @Override
    public void giveItem(BaseItemStack itemStack) {
        this.player.m_150109_().m_36054_(ForgeAdapter.adapt(itemStack));
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        Object send = event.getTypeId();
        if (params.length > 0) {
            send = (String)send + "|" + StringUtil.joinString(params, "|");
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.copiedBuffer((CharSequence)send, (Charset)StandardCharsets.UTF_8));
        WECUIPacketHandler.send(this.player.f_8906_.getConnection(), buffer);
    }

    private void sendMessage(Component textComponent) {
        this.player.m_213846_(textComponent);
    }

    @Override
    @Deprecated
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.sendMessage((Component)Component.m_237113_((String)part));
        }
    }

    @Override
    @Deprecated
    public void printDebug(String msg) {
        this.sendColorized(msg, ChatFormatting.GRAY);
    }

    @Override
    @Deprecated
    public void print(String msg) {
        this.sendColorized(msg, ChatFormatting.LIGHT_PURPLE);
    }

    @Override
    @Deprecated
    public void printError(String msg) {
        this.sendColorized(msg, ChatFormatting.RED);
    }

    @Override
    public void print(com.sk89q.worldedit.util.formatting.text.Component component) {
        this.sendMessage((Component)Component.Serializer.m_130701_((String)GsonComponentSerializer.INSTANCE.serialize(WorldEditText.format(component, this.getLocale()))));
    }

    private void sendColorized(String msg, ChatFormatting formatting) {
        for (String part : msg.split("\n")) {
            MutableComponent component = Component.m_237113_((String)part);
            component.m_130940_(formatting);
            this.sendMessage((Component)component);
        }
    }

    @Override
    public boolean trySetPosition(Vector3 pos, float pitch, float yaw) {
        this.player.f_8906_.m_9774_(pos.x(), pos.y(), pos.z(), yaw, pitch);
        return true;
    }

    @Override
    public String[] getGroups() {
        return new String[0];
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return null;
    }

    @Override
    public boolean hasPermission(String perm) {
        return ForgeWorldEdit.inst.getPermissionsProvider().hasPermission(this.player, perm);
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    @Override
    public boolean isAllowedToFly() {
        return this.player.m_150110_().f_35936_;
    }

    @Override
    public void setFlying(boolean flying) {
        if (this.player.m_150110_().f_35935_ != flying) {
            this.player.m_150110_().f_35935_ = flying;
            this.player.m_6885_();
        }
    }

    @Override
    public Locale getLocale() {
        return TextUtils.getLocaleByMinecraftTag(this.player.getLanguage());
    }

    @Override
    public <B extends BlockStateHolder<B>> void sendFakeBlock(BlockVector3 pos, B block) {
        World world = this.getWorld();
        if (!(world instanceof ForgeWorld)) {
            return;
        }
        BlockPos loc = ForgeAdapter.toBlockPos(pos);
        if (block == null) {
            ClientboundBlockUpdatePacket packetOut = new ClientboundBlockUpdatePacket((BlockGetter)((ForgeWorld)world).getWorld(), loc);
            this.player.f_8906_.m_141995_((Packet)packetOut);
        } else {
            this.player.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket(loc, ForgeAdapter.adapt(block.toImmutableState())));
            if (block instanceof BaseBlock) {
                LinCompoundTag nbtData;
                BaseBlock baseBlock = (BaseBlock)block;
                if (block.getBlockType().equals(BlockTypes.STRUCTURE_BLOCK) && (nbtData = baseBlock.getNbt()) != null) {
                    this.player.f_8906_.m_141995_((Packet)new ClientboundBlockEntityDataPacket(new BlockPos(pos.x(), pos.y(), pos.z()), BlockEntityType.f_58936_, NBTConverter.toNative(nbtData)));
                }
            }
        }
    }

    @Override
    public SessionKey getSessionKey() {
        return new SessionKeyImpl(this.player);
    }

    static class SessionKeyImpl
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        SessionKeyImpl(ServerPlayer player) {
            this.uuid = player.m_20148_();
            this.name = player.m_7755_().getString();
        }

        @Override
        public UUID getUniqueId() {
            return this.uuid;
        }

        @Override
        @Nullable
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isActive() {
            return ThreadSafeCache.getInstance().getOnlineIds().contains(this.uuid);
        }

        @Override
        public boolean isPersistent() {
            return true;
        }
    }
}

