/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.generic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.api.BRBBookCategories;
import marsh.town.brb.generic.GenericRecipe;
import marsh.town.brb.generic.GenericRecipeBookCollection;
import marsh.town.brb.generic.pins.Pinnable;
import marsh.town.brb.mixins.accessors.KeyMappingAccessor;
import marsh.town.brb.util.BRBTextures;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5455;
import net.minecraft.class_6382;

public class GenericRecipeButton<C extends GenericRecipeBookCollection<R, M>, R extends GenericRecipe, M extends class_1703>
extends class_339 {
    private final Supplier<Boolean> filteringSupplier;
    protected C collection;
    protected M menu;
    protected float time;
    protected int currentIndex;
    protected class_5455 registryAccess;
    protected BRBBookCategories.Category category;

    public GenericRecipeButton(class_5455 registryAccess, Supplier<Boolean> filteringSupplier) {
        super(0, 0, 25, 25, class_5244.field_39003);
        this.registryAccess = registryAccess;
        this.filteringSupplier = filteringSupplier;
    }

    public void showCollection(C collection, M smithingMenu, BRBBookCategories.Category category) {
        this.collection = collection;
        this.menu = smithingMenu;
        this.category = category;
    }

    public void method_48579(class_332 gui, int mouseX, int mouseY, float delta) {
        if (!class_437.method_25441()) {
            this.time += delta;
        }
        List<R> list = this.getOrderedRecipes();
        this.currentIndex = class_3532.method_15375((float)(this.time / 30.0f)) % list.size();
        class_2960 outlineTexture = ((GenericRecipeBookCollection)this.collection).atleastOneCraftable((class_2371<class_1735>)((class_1703)this.menu).field_7761) ? BRBTextures.RECIPE_BOOK_BUTTON_SLOT_CRAFTABLE_SPRITE : BRBTextures.RECIPE_BOOK_BUTTON_SLOT_UNCRAFTABLE_SPRITE;
        gui.method_52706(outlineTexture, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        class_1799 result = this.getCurrentDisplayedRecipe().getResult(this.registryAccess);
        int offset = 4;
        gui.method_51445(result, this.method_46426() + offset, this.method_46427() + offset);
        if (BetterRecipeBook.config.enablePinning && BetterRecipeBook.pinnedRecipeManager.has((Pinnable)this.collection)) {
            gui.method_52706(BRBTextures.RECIPE_BOOK_PIN_SPRITE, this.method_46426() - 4, this.method_46427() - 4, 32, 32);
        }
    }

    public R getCurrentDisplayedRecipe() {
        List<R> list = this.getOrderedRecipes();
        return (R)((GenericRecipe)list.get(this.currentIndex));
    }

    public boolean isOnlyOption() {
        return this.getOrderedRecipes().size() == 1;
    }

    public List<R> getOrderedRecipes() {
        List list = ((GenericRecipeBookCollection)this.getCollection()).getDisplayRecipes(true);
        if (!this.filteringSupplier.get().booleanValue()) {
            list.addAll(((GenericRecipeBookCollection)this.collection).getDisplayRecipes(false));
        }
        return list;
    }

    public C getCollection() {
        return this.collection;
    }

    public void method_47399(class_6382 builder) {
    }

    public int method_25368() {
        return 25;
    }

    protected boolean method_25351(int i) {
        return i == 0 || i == 1;
    }

    public List<class_2561> getTooltipText() {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.getCurrentDisplayedRecipe().getResult(this.registryAccess).method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)class_1836.field_41070));
        this.addPinTooltip(list);
        return list;
    }

    public void addPinTooltip(List<class_2561> list) {
        list.add((class_2561)class_2561.method_43473());
        if (BetterRecipeBook.config.enablePinning) {
            if (BetterRecipeBook.pinnedRecipeManager.has((Pinnable)this.collection)) {
                list.add((class_2561)class_2561.method_43469((String)"brb.gui.pin.remove", (Object[])new Object[]{((KeyMappingAccessor)BetterRecipeBook.PIN_MAPPING).getKey().method_27445()}));
            } else {
                list.add((class_2561)class_2561.method_43469((String)"brb.gui.pin.add", (Object[])new Object[]{((KeyMappingAccessor)BetterRecipeBook.PIN_MAPPING).getKey().method_27445()}));
            }
        }
    }
}

