/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.generic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.api.BRBBookCategories;
import marsh.town.brb.api.BRBBookSettings;
import marsh.town.brb.generic.BRBGroupButtonWidget;
import marsh.town.brb.generic.GenericClientRecipeBook;
import marsh.town.brb.generic.GenericGhostRecipe;
import marsh.town.brb.generic.GenericRecipe;
import marsh.town.brb.generic.GenericRecipeBookCollection;
import marsh.town.brb.generic.GenericRecipeButton;
import marsh.town.brb.generic.GenericRecipePage;
import marsh.town.brb.interfaces.IPinningComponent;
import marsh.town.brb.interfaces.ISettingsButton;
import marsh.town.brb.mixins.accessors.RecipeBookComponentAccessor;
import marsh.town.brb.util.BRBHelper;
import marsh.town.brb.util.BRBTextures;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_361;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_515;
import net.minecraft.class_5455;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericRecipeBookComponent<M extends class_1703, C extends GenericRecipeBookCollection<R, M>, R extends GenericRecipe>
implements class_4068,
class_6379,
class_364,
ISettingsButton,
class_515,
IPinningComponent<C> {
    protected static final class_2561 SEARCH_HINT = RecipeBookComponentAccessor.getSEARCH_HINT();
    protected static final class_2561 ALL_RECIPES_TOOLTIP = RecipeBookComponentAccessor.getALL_RECIPES_TOOLTIP();
    boolean visible;
    protected boolean ignoreTextInput;
    protected class_310 minecraft;
    protected class_342 searchBox;
    private String lastSearch;
    protected int xOffset;
    protected boolean widthTooNarrow;
    protected int width;
    protected int height;
    protected M menu;
    protected final class_1662 stackedContents = new class_1662();
    protected class_361 filterButton;
    protected class_344 settingsButton;
    public GenericRecipePage<M, C, R> recipesPage;
    protected final List<BRBGroupButtonWidget> tabButtons = Lists.newArrayList();
    @Nullable
    public BRBGroupButtonWidget selectedTab;
    protected GenericClientRecipeBook book;
    protected class_1863 recipeManager;
    private boolean doubleRefresh = true;
    protected class_5455 registryAccess;
    @Nullable
    public GenericGhostRecipe<R> ghostRecipe;

    protected GenericRecipeBookComponent() {
    }

    public abstract class_2561 getRecipeFilterName();

    public abstract BRBHelper.Book getRecipeBookType();

    public void init(int parentWidth, int parentHeight, class_310 client, boolean narrow, M menu, class_5455 registryAccess) {
        this.init(parentWidth, parentHeight, client, narrow, menu, null, registryAccess);
    }

    public void init(int width, int height, class_310 minecraft, boolean widthNarrow, M menu, @Nullable Consumer<class_1799> onGhostRecipeUpdate, class_5455 registryAccess) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
        this.menu = menu;
        this.widthTooNarrow = widthNarrow;
        if (this.minecraft.field_1724 == null) {
            return;
        }
        this.minecraft.field_1724.field_7512 = menu;
        this.setVisible(BRBBookSettings.isOpen(this.getRecipeBookType()));
        this.book = new GenericClientRecipeBook();
        this.registryAccess = registryAccess;
        this.ghostRecipe = new GenericGhostRecipe(onGhostRecipeUpdate, registryAccess);
    }

    public void initVisuals() {
        this.xOffset = BetterRecipeBook.config.keepCentered ? (this.widthTooNarrow ? 0 : 162) : (this.widthTooNarrow ? 0 : 86);
        int i = (this.width - 147) / 2 - this.xOffset;
        int j = (this.height - 166) / 2;
        this.stackedContents.method_7409();
        if (this.minecraft.field_1724 == null) {
            return;
        }
        this.minecraft.field_1724.method_31548().method_7387(this.stackedContents);
        String string = this.searchBox != null ? this.searchBox.method_1882() : "";
        Objects.requireNonNull(this.minecraft.field_1772);
        class_327 class_3272 = this.minecraft.field_1772;
        Objects.requireNonNull(this.minecraft.field_1772);
        this.searchBox = new class_342(class_3272, i + 25, j + 13, 81, 9 + 5, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1862(true);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1852(string);
        this.searchBox.method_47404(SEARCH_HINT);
        this.settingsButton = this.createSettingsButton(i, j);
        this.recipesPage.initialize(this.minecraft, i, j, this.menu, this.xOffset);
        this.tabButtons.clear();
        this.filterButton = new class_361(i + 110, j + 12, 26, 16, BRBBookSettings.isFiltering(this.getRecipeBookType()));
        this.updateFilterButtonTooltip();
        this.filterButton.method_1962(BRBTextures.RECIPE_BOOK_FILTER_BUTTON_SPRITES);
        List<BRBBookCategories.Category> categories = BRBBookCategories.getCategories(this.getRecipeBookType());
        if (categories == null) {
            throw new NullPointerException("Book category not registered");
        }
        for (BRBBookCategories.Category category : categories) {
            this.tabButtons.add(new BRBGroupButtonWidget(category));
        }
        if (this.selectedTab != null) {
            this.selectedTab = this.tabButtons.stream().filter(button -> button.getCategory().equals(this.selectedTab.getCategory())).findFirst().orElse(null);
        }
        if (this.selectedTab == null) {
            this.selectedTab = this.tabButtons.get(0);
        }
        this.selectedTab.method_1964(true);
        this.updateCollections(false);
        this.refreshTabButtons();
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        if (this.doubleRefresh) {
            this.updateCollections(true);
            this.doubleRefresh = false;
        }
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        int blitX = (this.width - 147) / 2 - this.xOffset;
        int blitY = (this.height - 166) / 2;
        gui.method_25302(BRBTextures.RECIPE_BOOK_BACKGROUND_TEXTURE, blitX, blitY, 1, 1, 147, 166);
        this.searchBox.method_25394(gui, mouseX, mouseY, delta);
        for (BRBGroupButtonWidget widget : this.tabButtons) {
            widget.method_25394(gui, mouseX, mouseY, delta);
        }
        this.filterButton.method_25394(gui, mouseX, mouseY, delta);
        ISettingsButton.super.renderSettingsButton(this.settingsButton, gui, mouseX, mouseY, delta);
        this.recipesPage.render(gui, blitX, blitY, mouseX, mouseY, delta);
        gui.method_51448().method_22909();
    }

    public boolean method_25404(int i, int j, int k) {
        this.ignoreTextInput = false;
        if (!this.isVisible() || this.minecraft.field_1724 != null && this.minecraft.field_1724.method_7325()) {
            return false;
        }
        if (i == 256 && !this.isOffsetNextToMainGUI()) {
            this.setVisible(false);
            return true;
        }
        if (this.searchBox.method_25404(i, j, k)) {
            this.checkSearchStringUpdate();
            return true;
        }
        if (this.searchBox.method_25370() && this.searchBox.method_1885() && i != 256) {
            return true;
        }
        if (this.minecraft.field_1690.field_1890.method_1417(i, j) && !this.searchBox.method_25370()) {
            this.ignoreTextInput = true;
            this.searchBox.method_25365(true);
            return true;
        }
        if (BetterRecipeBook.PIN_MAPPING.method_1417(i, j) && BetterRecipeBook.config.enablePinning) {
            for (GenericRecipeButton resultButton : this.recipesPage.buttons) {
                if (!resultButton.method_25367()) continue;
                BetterRecipeBook.pinnedRecipeManager.addOrRemoveFavourite(resultButton.getCollection());
                this.updateCollections(false);
                return true;
            }
        }
        return false;
    }

    public abstract void handlePlaceRecipe();

    public boolean method_16803(int i, int j, int k) {
        this.ignoreTextInput = false;
        return super.method_16803(i, j, k);
    }

    public boolean method_25400(char c, int i) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (!this.isVisible() || this.minecraft.field_1724 != null && this.minecraft.field_1724.method_7325()) {
            return false;
        }
        if (this.searchBox.method_25400(c, i)) {
            this.checkSearchStringUpdate();
            return true;
        }
        return super.method_25400(c, i);
    }

    private void checkSearchStringUpdate() {
        String string = this.searchBox.method_1882().toLowerCase(Locale.ROOT);
        this.pirateSpeechForThePeople(string);
        if (!string.equals(this.lastSearch)) {
            this.updateCollections(false);
            this.lastSearch = string;
        }
    }

    protected void updateCollections(boolean b) {
        if (this.selectedTab == null) {
            return;
        }
        if (this.searchBox == null) {
            return;
        }
        ArrayList<C> results = new ArrayList<C>(this.getCollectionsForCategory());
        String string = this.searchBox.method_1882();
        if (!string.isEmpty()) {
            results.removeIf(collection -> !collection.getFirst().getSearchString().toLowerCase(Locale.ROOT).contains(string.toLowerCase(Locale.ROOT)));
        }
        if (BRBBookSettings.isFiltering(this.getRecipeBookType())) {
            results.removeIf(result -> !result.atleastOneCraftable((class_2371<class_1735>)((class_1703)this.menu).field_7761));
        }
        this.betterRecipeBook$sortByPinsInPlace(results);
        this.recipesPage.setResults(results, b, this.selectedTab.getCategory());
    }

    private void pirateSpeechForThePeople(String string) {
        if ("excitedze".equals(string)) {
            class_1076 languageManager = this.minecraft.method_1526();
            String string2 = "en_pt";
            class_1077 languageInfo = languageManager.method_4668("en_pt");
            if (languageInfo == null || languageManager.method_4669().equals("en_pt")) {
                return;
            }
            languageManager.method_4667("en_pt");
            this.minecraft.field_1690.field_1883 = "en_pt";
            this.minecraft.method_1521();
            this.minecraft.field_1690.method_1640();
        }
    }

    private boolean isOffsetNextToMainGUI() {
        return this.xOffset == 86;
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return this.isVisible() ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    protected void setVisible(boolean visible) {
        BRBBookSettings.setOpen(this.getRecipeBookType(), visible);
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    public boolean hasClickedOutside(double d, double e, int i, int j, int k, int l, int m) {
        if (!this.isVisible()) {
            return true;
        }
        boolean bl = d < (double)i || e < (double)j || d >= (double)(i + k) || e >= (double)(j + l);
        boolean bl2 = (double)(i - 147) < d && d < (double)i && (double)j < e && e < (double)(j + l);
        return bl && !bl2;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.recipesPage.mouseClicked(mouseX, mouseY, button, (this.width - 147) / 2 - this.xOffset, (this.height - 166) / 2, 147, 166)) {
            this.handlePlaceRecipe();
            return true;
        }
        if (this.searchBox.method_25402(mouseX, mouseY, button)) {
            this.searchBox.method_25365(true);
            this.ignoreTextInput = true;
            return true;
        }
        this.searchBox.method_25365(false);
        this.ignoreTextInput = false;
        if (this.filterButton.method_25402(mouseX, mouseY, button)) {
            boolean bl = this.toggleFiltering();
            this.filterButton.method_1964(bl);
            this.updateFilterButtonTooltip();
            this.updateCollections(false);
            return true;
        }
        if (ISettingsButton.super.settingsButtonMouseClicked(this.settingsButton, mouseX, mouseY, button)) {
            return true;
        }
        Iterator<BRBGroupButtonWidget> tabButtonsIter = this.tabButtons.iterator();
        if (!tabButtonsIter.hasNext()) {
            return false;
        }
        BRBGroupButtonWidget widget = tabButtonsIter.next();
        while (!widget.method_25402(mouseX, mouseY, button)) {
            if (!tabButtonsIter.hasNext()) {
                return false;
            }
            widget = tabButtonsIter.next();
        }
        if (this.selectedTab != widget) {
            if (this.selectedTab != null) {
                this.selectedTab.method_1964(false);
            }
            this.selectedTab = widget;
            this.selectedTab.method_1964(true);
            this.updateCollections(true);
        }
        return false;
    }

    protected boolean toggleFiltering() {
        boolean bl = !BRBBookSettings.isFiltering(this.getRecipeBookType());
        BRBBookSettings.setFiltering(this.getRecipeBookType(), bl);
        return bl;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public void method_25365(boolean bl) {
    }

    public boolean method_25370() {
        return false;
    }

    protected void updateFilterButtonTooltip() {
        this.filterButton.method_47400(this.filterButton.method_1965() ? class_7919.method_47407((class_2561)this.getRecipeFilterName()) : class_7919.method_47407((class_2561)ALL_RECIPES_TOOLTIP));
    }

    public int findLeftEdge(int width, int backgroundWidth) {
        int j = this.isVisible() && !this.widthTooNarrow ? 177 + (width - backgroundWidth - 200) / 2 : (width - backgroundWidth) / 2;
        return j;
    }

    public void drawTooltip(class_332 gui, int x, int y, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.recipesPage.overlayIsVisible()) {
            this.recipesPage.drawTooltip(gui, mouseX, mouseY);
            ISettingsButton.super.renderSettingsButtonTooltip(this.settingsButton, gui, mouseX, mouseY);
        }
        this.ghostRecipe.drawTooltip(gui, x, y, mouseX, mouseY);
    }

    protected void refreshTabButtons() {
        int i = (this.width - 147) / 2 - this.xOffset - 30;
        int j = (this.height - 166) / 2 + 3;
        int l = 0;
        for (BRBGroupButtonWidget button : this.tabButtons) {
            BRBBookCategories.Category category = button.getCategory();
            if (category.getType() == BRBBookCategories.Category.Type.SEARCH) {
                button.field_22764 = true;
            }
            button.method_48229(i, j + 27 * l++);
        }
    }

    public void renderGhostRecipe(class_332 guiGraphics, int x, int y, boolean bl, float delta) {
        this.ghostRecipe.render(guiGraphics, this.minecraft, x, y, bl, delta);
    }

    protected abstract List<C> getCollectionsForCategory();

    public void method_2646(List<class_8786<?>> list) {
    }
}

