/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.generic;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import marsh.town.brb.generic.GenericRecipe;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;

public class GenericGhostRecipe<R extends GenericRecipe> {
    @Nullable
    protected Consumer<class_1799> onGhostUpdate;
    @Nullable
    protected R recipe;
    protected final List<GenericGhostIngredient> ingredients = Lists.newArrayList();
    protected float time;
    protected class_5455 registryAccess;
    @Nullable
    private BiPredicate<GhostRenderType, GenericGhostIngredient> renderingPredicate;

    public GenericGhostRecipe(@Nullable Consumer<class_1799> onGhostUpdate, class_5455 registryAccess) {
        this.onGhostUpdate = onGhostUpdate;
        this.registryAccess = registryAccess;
    }

    public void setRenderingPredicate(@Nullable BiPredicate<GhostRenderType, GenericGhostIngredient> renderingPredicate) {
        this.renderingPredicate = renderingPredicate;
    }

    public <T extends class_1703> void setDefaultRenderingPredicate(T menu) {
        this.setRenderingPredicate((type, ingredient) -> {
            class_1799 slot = ((class_1735)menu.field_7761.get(ingredient.getContainerSlot())).method_7677();
            switch (type) {
                case ITEM: 
                case BACKGROUND: 
                case TOOLTIP: {
                    return slot.method_7960();
                }
            }
            return true;
        });
    }

    public class_1799 getCurrentResult() {
        if (this.recipe == null) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = this.recipe.getResult(this.registryAccess);
        return itemStack.method_7972();
    }

    public void clear() {
        this.recipe = null;
        this.ingredients.clear();
        this.time = 0.0f;
    }

    public void addIngredient(int containerSlot, class_1856 ingredient, int i, int j) {
        this.ingredients.add(new GenericGhostIngredient(containerSlot, ingredient, i, j));
    }

    public GenericGhostIngredient get(int i) {
        return this.ingredients.get(i);
    }

    public int size() {
        return this.ingredients.size();
    }

    @Nullable
    public R getRecipe() {
        return this.recipe;
    }

    public void setRecipe(@Nullable R recipe) {
        this.recipe = recipe;
    }

    public void render(class_332 guiGraphics, class_310 minecraft, int i, int j, boolean bl, float f) {
        if (!class_437.method_25441()) {
            this.time += f;
            if (this.onGhostUpdate != null && this.recipe != null) {
                this.onGhostUpdate.accept(this.getCurrentResult());
            }
        }
        for (int k = 0; k < this.ingredients.size(); ++k) {
            GenericGhostIngredient ghostIngredient = this.ingredients.get(k);
            boolean shouldRenderBackground = this.renderingPredicate != null && this.renderingPredicate.test(GhostRenderType.BACKGROUND, ghostIngredient);
            boolean shouldRenderItem = this.renderingPredicate != null && this.renderingPredicate.test(GhostRenderType.ITEM, ghostIngredient);
            int l = ghostIngredient.getX() + i;
            int m = ghostIngredient.getY() + j;
            if (shouldRenderBackground) {
                if (k == 0 && bl) {
                    guiGraphics.method_25294(l - 4, m - 4, l + 20, m + 20, 0x30FF0000);
                } else {
                    guiGraphics.method_25294(l, m, l + 16, m + 16, 0x30FF0000);
                }
            }
            class_1799 itemStack = ghostIngredient.getItem();
            if (shouldRenderItem) {
                guiGraphics.method_51445(itemStack, l, m);
            }
            if (shouldRenderBackground) {
                guiGraphics.method_51739(class_1921.method_51787(), l, m, l + 16, m + 16, 0x30FFFFFF);
            }
            if (k != 0) continue;
            guiGraphics.method_51431(minecraft.field_1772, itemStack, l, m);
        }
    }

    public GenericGhostIngredient getBySlot(int i) {
        for (GenericGhostIngredient ingredient : this.ingredients) {
            if (ingredient.getContainerSlot() != i) continue;
            return ingredient;
        }
        return null;
    }

    public void drawTooltip(class_332 gui, int x, int y, int mouseX, int mouseY) {
        class_1799 itemStack = null;
        for (GenericGhostIngredient ingredient : this.ingredients) {
            int j = ingredient.getX() + x;
            int k = ingredient.getY() + y;
            if (mouseX < j || mouseY < k || mouseX >= j + 16 || mouseY >= k + 16 || this.renderingPredicate != null && !this.renderingPredicate.test(GhostRenderType.TOOLTIP, ingredient)) continue;
            itemStack = ingredient.getItem();
        }
        if (itemStack != null && class_310.method_1551().field_1755 != null) {
            gui.method_51434(class_310.method_1551().field_1772, class_437.method_25408((class_310)class_310.method_1551(), itemStack), mouseX, mouseY);
        }
    }

    public class GenericGhostIngredient {
        private final class_1856 ingredient;
        private final int x;
        private final int y;
        private final int containerSlot;

        public GenericGhostIngredient(int containerSlot, class_1856 ingredient, int i, int j) {
            this.containerSlot = containerSlot;
            this.ingredient = ingredient;
            this.x = i;
            this.y = j;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public class_1799 getItem() {
            class_1799[] itemStacks = this.ingredient.method_8105();
            return itemStacks.length == 0 ? class_1799.field_8037 : itemStacks[class_3532.method_15375((float)(GenericGhostRecipe.this.time / 30.0f)) % itemStacks.length];
        }

        public int getContainerSlot() {
            return this.containerSlot;
        }

        public GenericGhostRecipe<R> getOwner() {
            return GenericGhostRecipe.this;
        }
    }

    public static enum GhostRenderType {
        ITEM,
        BACKGROUND,
        TOOLTIP;

    }
}

