/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.brewingstand;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.api.BRBBookCategories;
import marsh.town.brb.api.BRBBookSettings;
import marsh.town.brb.brewingstand.BrewableRecipeButton;
import marsh.town.brb.brewingstand.BrewableResult;
import marsh.town.brb.brewingstand.BrewingRecipeCollection;
import marsh.town.brb.brewingstand.PlatformPotionUtil;
import marsh.town.brb.generic.GenericRecipeBookComponent;
import marsh.town.brb.generic.GenericRecipePage;
import marsh.town.brb.interfaces.IPinningComponent;
import marsh.town.brb.loaders.PotionLoader;
import marsh.town.brb.mixins.accessors.BrewingStandMenuAccessor;
import marsh.town.brb.util.BRBHelper;
import marsh.town.brb.util.ClientInventoryUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1708;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class BrewingRecipeBookComponent
extends GenericRecipeBookComponent<class_1708, BrewingRecipeCollection, BrewableResult>
implements IPinningComponent<BrewingRecipeCollection> {
    private static final class_2561 ONLY_CRAFTABLES_TOOLTIP = class_2561.method_43471((String)"brb.gui.togglePotions.brewable");

    @Override
    public void init(int parentWidth, int parentHeight, class_310 client, boolean narrow, class_1708 menu, Consumer<class_1799> onGhostRecipeUpdate, class_5455 registryAccess) {
        super.init(parentWidth, parentHeight, client, narrow, menu, onGhostRecipeUpdate, registryAccess);
        this.recipesPage = new GenericRecipePage(registryAccess, () -> new BrewableRecipeButton(registryAccess, () -> BRBBookSettings.isFiltering(this.getRecipeBookType())));
        this.initVisuals();
        this.ghostRecipe.setRenderingPredicate((type, ingredient) -> {
            class_1799 slot = ((class_1735)menu.field_7761.get(ingredient.getContainerSlot())).method_7677();
            switch (type) {
                case ITEM: 
                case BACKGROUND: {
                    class_1799 ghost;
                    class_1799 class_17992 = ghost = ingredient.getContainerSlot() == BrewingStandMenuAccessor.getBOTTLE_SLOT_START() ? ingredient.getOwner().getBySlot(1).getItem() : ingredient.getItem();
                    if (ingredient.getContainerSlot() >= BrewingStandMenuAccessor.getBOTTLE_SLOT_START() && ingredient.getContainerSlot() <= BrewingStandMenuAccessor.getBOTTLE_SLOT_END()) {
                        class_1842 ghostPotion;
                        if (!(slot.method_7909() instanceof class_1812)) {
                            return true;
                        }
                        class_1842 slotPotion = class_1844.method_8063((class_1799)slot);
                        return !slotPotion.equals(ghostPotion = class_1844.method_8063((class_1799)ghost));
                    }
                    return !slot.method_31574(ghost.method_7909());
                }
                case TOOLTIP: {
                    return slot.method_7960();
                }
            }
            return true;
        });
    }

    public class_1799 getInputStack(BrewableResult result) {
        class_1842 inputPotion = PlatformPotionUtil.getFrom(result.recipe);
        class_1856 ingredient = PlatformPotionUtil.getIngredient(result.recipe);
        class_2960 identifier = class_7923.field_41179.method_10221((Object)inputPotion);
        class_1799 inputStack = this.selectedTab.getCategory() == BetterRecipeBook.BREWING_SPLASH_POTION ? new class_1799((class_1935)class_1802.field_8436) : (this.selectedTab.getCategory() == BetterRecipeBook.BREWING_LINGERING_POTION ? new class_1799((class_1935)class_1802.field_8150) : new class_1799((class_1935)class_1802.field_8574));
        inputStack.method_7948().method_10582("Potion", identifier.toString());
        return inputStack;
    }

    public void setupGhostRecipe(BrewableResult result, List<class_1735> slots) {
        this.ghostRecipe.addIngredient(BrewingStandMenuAccessor.getINGREDIENT_SLOT(), class_1856.method_8101((class_1799[])new class_1799[]{PlatformPotionUtil.getIngredient(result.recipe).method_8105()[0]}), slots.get((int)BrewingStandMenuAccessor.getINGREDIENT_SLOT()).field_7873, slots.get((int)BrewingStandMenuAccessor.getINGREDIENT_SLOT()).field_7872);
        assert (this.selectedTab != null);
        class_1799 inputStack = result.inputAsItemStack(this.selectedTab.getCategory());
        for (int i = BrewingStandMenuAccessor.getBOTTLE_SLOT_START(); i <= BrewingStandMenuAccessor.getBOTTLE_SLOT_END(); ++i) {
            this.ghostRecipe.addIngredient(i, class_1856.method_8101((class_1799[])new class_1799[]{inputStack}), slots.get((int)i).field_7873, slots.get((int)i).field_7872);
        }
    }

    @Override
    protected List<BrewingRecipeCollection> getCollectionsForCategory() {
        ArrayList<BrewingRecipeCollection> results;
        block4: {
            BRBBookCategories.Category category;
            block5: {
                block3: {
                    results = new ArrayList<BrewingRecipeCollection>();
                    category = this.selectedTab.getCategory();
                    if (category != BetterRecipeBook.BREWING_POTION) break block3;
                    for (BrewableResult potion : PotionLoader.POTIONS) {
                        results.add(new BrewingRecipeCollection(List.of(potion), (class_1708)this.menu, this.registryAccess, category));
                    }
                    break block4;
                }
                if (category != BetterRecipeBook.BREWING_SPLASH_POTION) break block5;
                for (BrewableResult splash : PotionLoader.SPLASHES) {
                    results.add(new BrewingRecipeCollection(List.of(splash), (class_1708)this.menu, this.registryAccess, category));
                }
                break block4;
            }
            if (category != BetterRecipeBook.BREWING_LINGERING_POTION) break block4;
            for (BrewableResult splash : PotionLoader.LINGERINGS) {
                results.add(new BrewingRecipeCollection(List.of(splash), (class_1708)this.menu, this.registryAccess, category));
            }
        }
        return results;
    }

    @Override
    public class_2561 getRecipeFilterName() {
        return ONLY_CRAFTABLES_TOOLTIP;
    }

    @Override
    public BRBHelper.Book getRecipeBookType() {
        return BetterRecipeBook.BREWING;
    }

    @Override
    public void handlePlaceRecipe() {
        BrewableResult result = (BrewableResult)this.recipesPage.getCurrentClickedRecipe();
        if (result == null) {
            return;
        }
        this.ghostRecipe.clear();
        if (!result.hasMaterials(this.selectedTab.getCategory(), (List<class_1735>)((class_1708)this.menu).field_7761)) {
            this.setupGhostRecipe(result, (List<class_1735>)((class_1708)this.menu).field_7761);
            return;
        }
        class_1799 inputStack = this.getInputStack(result);
        class_1856 ingredient = PlatformPotionUtil.getIngredient(result.recipe);
        int slotIndex = 0;
        int usedInputSlots = 0;
        for (class_1735 slot : ((class_1708)this.menu).field_7761) {
            class_1799 itemStack = slot.method_7677();
            assert (inputStack.method_7969() != null);
            if (inputStack.method_7969().equals((Object)itemStack.method_7969()) && inputStack.method_7909().equals(itemStack.method_7909())) {
                if (usedInputSlots <= 2) {
                    assert (class_310.method_1551().field_1761 != null);
                    ClientInventoryUtil.storeItem(-1, i -> i > 4);
                    class_310.method_1551().field_1761.method_2906(((class_1708)this.menu).field_7763, ((class_1708)this.menu).method_7611((int)slotIndex).field_7874, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
                    class_310.method_1551().field_1761.method_2906(((class_1708)this.menu).field_7763, ((class_1708)this.menu).method_7611((int)usedInputSlots).field_7874, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
                    ClientInventoryUtil.storeItem(-1, i -> i > 4);
                    ++usedInputSlots;
                }
            } else if (ingredient.method_8105()[0].method_7909().equals(slot.method_7677().method_7909())) {
                assert (class_310.method_1551().field_1761 != null);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
                class_310.method_1551().field_1761.method_2906(((class_1708)this.menu).field_7763, ((class_1708)this.menu).method_7611((int)slotIndex).field_7874, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
                class_310.method_1551().field_1761.method_2906(((class_1708)this.menu).field_7763, ((class_1708)this.menu).method_7611((int)3).field_7874, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
            }
            ++slotIndex;
        }
        this.updateCollections(false);
    }

    public void recipesUpdated() {
        this.updateCollections(false);
    }
}

