/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.generic.GenericRecipe;
import marsh.town.brb.generic.GenericRecipeBookCollection;
import marsh.town.brb.generic.pins.Pinnable;
import marsh.town.brb.mixins.accessors.RecipeBookComponentAccessor;
import net.minecraft.class_1703;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_507;
import net.minecraft.class_513;
import net.minecraft.class_516;
import net.minecraft.class_8786;
import org.apache.commons.io.IOUtils;

public class PinnedRecipeManager {
    public HashSet<class_2960> pinned;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        Gson gson = new Gson();
        JsonReader reader = null;
        try {
            File pinsFile = new File(class_310.method_1551().field_1697, "brb.pins");
            if (pinsFile.exists()) {
                reader = new JsonReader((Reader)new FileReader(pinsFile.getAbsolutePath()));
                Type type = new TypeToken<HashSet<class_2960>>(){}.getType();
                this.pinned = (HashSet)gson.fromJson(reader, type);
            }
        }
        catch (Throwable var8) {
            BetterRecipeBook.LOGGER.error("brb.pins could not be read.");
        }
        finally {
            if (this.pinned == null) {
                this.pinned = new HashSet();
            }
            IOUtils.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() {
        Gson gson = new Gson();
        OutputStreamWriter writer = null;
        try {
            File pinsFile = new File(class_310.method_1551().field_1697, "brb.pins");
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(pinsFile), StandardCharsets.UTF_8);
            writer.write(gson.toJson(this.pinned));
        }
        catch (Throwable var8) {
            try {
                BetterRecipeBook.LOGGER.error("brb.pins could not be saved.");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(writer);
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void addOrRemoveFavourite(class_516 target) {
        for (class_2960 identifier : this.pinned) {
            for (class_8786 recipe : target.method_2650()) {
                if (!recipe.comp_1932().equals((Object)identifier)) continue;
                this.pinned.remove(identifier);
                this.store();
                return;
            }
        }
        this.pinned.addAll(target.method_2650().stream().map(class_8786::comp_1932).toList());
        this.store();
    }

    public <R extends GenericRecipe, M extends class_1703> void addOrRemoveFavourite(GenericRecipeBookCollection<R, M> target) {
        for (class_2960 identifier : this.pinned) {
            for (GenericRecipe recipe : target.getRecipes()) {
                if (!recipe.id().equals((Object)identifier)) continue;
                this.pinned.remove(identifier);
                this.store();
                return;
            }
        }
        this.pinned.addAll(target.getRecipes().stream().map(GenericRecipe::id).toList());
        this.store();
    }

    public boolean has(Pinnable target) {
        for (class_2960 identifier : this.pinned) {
            if (!target.has(identifier)) continue;
            return true;
        }
        return false;
    }

    public static void handlePinRecipe(class_507 book, class_513 page, class_8786<?> recipe) {
        class_516 collection = new class_516(class_310.method_1551().field_1687.method_30349(), List.of(recipe));
        collection.method_2647(page.method_2633());
        BetterRecipeBook.pinnedRecipeManager.addOrRemoveFavourite(collection);
        ((RecipeBookComponentAccessor)book).updateCollectionsInvoker(false);
    }
}

