/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.replayvoicechat.net;

import de.maxhenkel.replayvoicechat.Utils;
import de.maxhenkel.replayvoicechat.net.Packet;
import de.maxhenkel.replayvoicechat.net.VersionCompatibilityException;
import java.util.UUID;
import net.minecraft.class_2540;

public abstract class AbstractSoundPacket<T extends Packet<T>>
implements Packet<T> {
    public static final short CURRENT_VERSION = 1;
    protected short version;
    protected UUID id;
    protected short[] rawAudio;

    public AbstractSoundPacket(UUID id, short[] rawAudio) {
        this.version = 1;
        this.id = id;
        this.rawAudio = rawAudio;
    }

    public AbstractSoundPacket() {
    }

    public UUID getId() {
        return this.id;
    }

    public short[] getRawAudio() {
        return this.rawAudio;
    }

    @Override
    public T fromBytes(class_2540 buf) throws VersionCompatibilityException {
        this.version = buf.readShort();
        if (this.version != 1 && this.version != 0) {
            throw new VersionCompatibilityException("Incompatible version");
        }
        this.id = buf.method_10790();
        this.rawAudio = Utils.bytesToShorts(buf.method_10795());
        return (T)this;
    }

    @Override
    public void toBytes(class_2540 buf) {
        buf.method_52998((int)this.version);
        buf.method_10797(this.id);
        buf.method_10813(Utils.shortsToBytes(this.rawAudio));
    }
}

