/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.replayvoicechat;

public class Utils {
    public static short[] bytesToShorts(byte[] bytes) {
        if (bytes.length % 2 != 0) {
            throw new IllegalArgumentException("Input bytes need to be divisible by 2");
        }
        short[] data = new short[bytes.length / 2];
        for (int i = 0; i < bytes.length; i += 2) {
            data[i / 2] = Utils.bytesToShort(bytes[i], bytes[i + 1]);
        }
        return data;
    }

    public static byte[] shortsToBytes(short[] shorts) {
        byte[] data = new byte[shorts.length * 2];
        for (int i = 0; i < shorts.length; ++i) {
            byte[] split = Utils.shortToBytes(shorts[i]);
            data[i * 2] = split[0];
            data[i * 2 + 1] = split[1];
        }
        return data;
    }

    public static short bytesToShort(byte b1, byte b2) {
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public static byte[] shortToBytes(short s) {
        return new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
    }
}

