/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.rendering;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wjbaker.ccm.crosshair.custom.CustomCrosshairDrawer;
import com.wjbaker.ccm.gui.types.GuiBounds;
import com.wjbaker.ccm.gui.types.IDrawInsideWindowCallback;
import com.wjbaker.ccm.rendering.types.RGBA;
import net.minecraft.class_1041;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.lwjgl.opengl.GL11;

public final class RenderManager {
    private void setGlProperty(int property, boolean isEnabled) {
        if (isEnabled) {
            GL11.glEnable((int)property);
        } else {
            GL11.glDisable((int)property);
        }
    }

    private void preRender(class_4587 matrixStack) {
        matrixStack.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
    }

    private void postRender(class_4587 matrixStack) {
        RenderSystem.disableBlend();
        matrixStack.method_22909();
    }

    public void drawLines(class_4587 matrixStack, float[] points, float thickness, RGBA colour) {
        this.drawLines(matrixStack, points, thickness, colour, false);
    }

    public void drawLines(class_4587 matrixStack, float[] points, float thickness, RGBA colour, boolean isBlendEnabled) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_29337);
        this.preRender(matrixStack);
        if (isBlendEnabled) {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }
        for (int i = 0; i < points.length; i += 2) {
            bufferBuilder.method_22918(matrixStack.method_23760().method_23761(), points[i], points[i + 1], 0.0f).method_1336(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getOpacity()).method_23763(matrixStack.method_23760().method_23762(), 0.0f, 0.0f, 0.0f).method_1344();
        }
        RenderSystem.lineWidth((float)thickness);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        this.postRender(matrixStack);
    }

    public void drawFilledShape(class_4587 matrixStack, float[] points, RGBA colour) {
        this.drawFilledShape(matrixStack, points, colour, false);
    }

    public void drawFilledShape(class_4587 matrixStack, float[] points, RGBA colour, boolean isBlendEnabled) {
        this.setGlProperty(2848, false);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        this.preRender(matrixStack);
        if (isBlendEnabled) {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }
        for (int i = 0; i < points.length; i += 2) {
            bufferBuilder.method_22918(matrixStack.method_23760().method_23761(), points[i], points[i + 1], 0.0f).method_1336(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getOpacity()).method_1344();
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        this.postRender(matrixStack);
    }

    public void drawLine(class_4587 matrixStack, float x1, float y1, float x2, float y2, float thickness, RGBA colour) {
        this.drawLines(matrixStack, new float[]{x1, y1, x2, y2}, thickness, colour);
    }

    public void drawRectangle(class_4587 matrixStack, float x1, float y1, float x2, float y2, float thickness, RGBA colour) {
        this.drawLines(matrixStack, new float[]{x1, y1, x2, y1, x2, y1, x2, y2, x1, y2, x2, y2, x1, y1, x1, y2}, thickness, colour);
    }

    public void drawFilledRectangle(class_4587 matrixStack, float x1, float y1, float x2, float y2, RGBA colour) {
        this.drawFilledRectangle(matrixStack, x1, y1, x2, y2, colour, false);
    }

    public void drawFilledRectangle(class_4587 matrixStack, float x1, float y1, float x2, float y2, RGBA colour, boolean isBlend) {
        this.drawFilledShape(matrixStack, new float[]{x1, y1, x1, y2, x2, y2, x2, y1}, colour, isBlend);
    }

    public void drawBorderedRectangle(class_4587 matrixStack, float x1, float y1, float x2, float y2, float borderThickness, RGBA borderColour, RGBA fillColour) {
        this.drawBorderedRectangle(matrixStack, x1, y1, x2, y2, borderThickness, borderColour, fillColour, false);
    }

    public void drawBorderedRectangle(class_4587 matrixStack, float x1, float y1, float x2, float y2, float borderThickness, RGBA borderColour, RGBA fillColour, boolean isBlend) {
        this.drawFilledRectangle(matrixStack, x1, y1, x2, y2, fillColour, isBlend);
        this.drawRectangle(matrixStack, x1, y1, x2, y2, borderThickness, borderColour);
    }

    public void drawPartialCircle(class_4587 matrixStack, float x, float y, float radius, int startAngleAt, int endAngleAt, float thickness, RGBA colour) {
        this.setGlProperty(2848, true);
        int startAngle = Math.max(0, Math.min(startAngleAt, endAngleAt));
        int endAngle = Math.min(360, Math.max(startAngleAt, endAngleAt));
        RenderSystem.lineWidth((float)thickness);
        float ratio = (float)Math.PI / 180;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_29337);
        this.preRender(matrixStack);
        for (int i = startAngle; i <= endAngle; ++i) {
            float radians = (float)(i - 90) * ratio;
            bufferBuilder.method_22918(matrixStack.method_23760().method_23761(), x + (float)Math.cos(radians) * radius, y + (float)Math.sin(radians) * radius, 0.0f).method_1336(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getOpacity()).method_23763(matrixStack.method_23760().method_23762(), 0.0f, 0.0f, 0.0f).method_1344();
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        this.postRender(matrixStack);
    }

    public void drawCircle(class_4587 matrixStack, float x, float y, float radius, float thickness, RGBA colour) {
        this.drawPartialCircle(matrixStack, x, y, radius, 0, 360, thickness, colour);
    }

    public void drawTorus(class_4587 matrixStack, int x, int y, int innerRadius, int outerRadius, RGBA colour) {
        this.setGlProperty(2848, true);
        float ratio = (float)Math.PI / 180;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_29337);
        this.preRender(matrixStack);
        for (int i = 0; i <= 360; ++i) {
            float radians = (float)(i - 90) * ratio;
            bufferBuilder.method_22918(matrixStack.method_23760().method_23761(), (float)x + (float)Math.cos(radians) * (float)innerRadius, (float)y + (float)Math.sin(radians) * (float)innerRadius, 0.0f).method_1336(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getOpacity()).method_23763(matrixStack.method_23760().method_23762(), 0.0f, 0.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrixStack.method_23760().method_23761(), (float)x + (float)Math.cos(radians) * (float)outerRadius, (float)y + (float)Math.sin(radians) * (float)outerRadius, 0.0f).method_1336(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getOpacity()).method_23763(matrixStack.method_23760().method_23762(), 0.0f, 0.0f, 0.0f).method_1344();
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        this.postRender(matrixStack);
    }

    public void drawImage(class_4587 matrixStack, int x, int y, CustomCrosshairDrawer image, RGBA colour, boolean isCentered) {
        float offsetX = isCentered ? (float)image.getWidth() / 2.0f : 0.0f;
        float offsetY = isCentered ? (float)image.getHeight() / 2.0f : 0.0f;
        int width = image.getWidth();
        int height = image.getHeight();
        for (int imageX = 0; imageX < width; ++imageX) {
            for (int imageY = 0; imageY < height; ++imageY) {
                if (image.getAt(imageX, imageY) != 1) continue;
                float drawX = (float)(x + imageX) - offsetX;
                float drawY = (float)(y + imageY) - offsetY;
                this.drawFilledRectangle(matrixStack, drawX, drawY, drawX + 1.0f, drawY + 1.0f, colour);
            }
        }
    }

    public void drawText(class_332 drawContext, String text, int x, int y, RGBA colour, boolean hasShadow) {
        int colourAsInt = this.rgbaAsInt(colour);
        if (hasShadow) {
            drawContext.method_25303(class_310.method_1551().field_1772, text, x, y, colourAsInt);
        } else {
            drawContext.method_51433(class_310.method_1551().field_1772, text, x, y, colourAsInt, false);
        }
    }

    public void drawSmallText(class_332 drawContext, String text, int x, int y, RGBA colour, boolean hasShadow) {
        class_4587 matrixStack = drawContext.method_51448();
        matrixStack.method_22903();
        matrixStack.method_22905(0.5f, 0.5f, 1.0f);
        RenderSystem.applyModelViewMatrix();
        this.drawText(drawContext, text, x * 2, y * 2, colour, hasShadow);
        matrixStack.method_22909();
    }

    public void drawBigText(class_332 drawContext, String text, int x, int y, RGBA colour, boolean hasShadow) {
        class_4587 matrixStack = drawContext.method_51448();
        matrixStack.method_22903();
        matrixStack.method_22905(1.5f, 1.5f, 1.0f);
        RenderSystem.applyModelViewMatrix();
        this.drawText(drawContext, text, (int)((float)x * 0.666f), (int)((float)y * 0.666f), colour, hasShadow);
        matrixStack.method_22909();
    }

    private int rgbaAsInt(RGBA colour) {
        return (colour.getOpacity() << 24) + (colour.getRed() << 16) + (colour.getGreen() << 8) + colour.getBlue();
    }

    public int textWidth(String text) {
        return class_310.method_1551().field_1772.method_1727(text);
    }

    public void drawInsideBounds(GuiBounds bounds, IDrawInsideWindowCallback callback) {
        this.setGlProperty(3089, true);
        class_1041 window = class_310.method_1551().method_22683();
        double scale = window.method_4495();
        GL11.glScissor((int)((int)Math.round((double)bounds.x() * scale)), (int)((int)Math.round((double)window.method_4507() - (double)bounds.y() * scale - (double)bounds.height() * scale)), (int)((int)Math.round((double)bounds.width() * scale)), (int)((int)Math.round((double)bounds.height() * scale)));
        callback.draw();
        this.setGlProperty(3089, false);
    }
}

