/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import com.misterpemodder.shulkerboxtooltip.fabric.ShulkerBoxTooltipImpl;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.config.ConfigurationHandler;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.provider.BlockEntityAwarePreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.provider.EnderChestPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.provider.ShulkerBoxPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.util.NamedLogger;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2589;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2608;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_3720;
import net.minecraft.class_3723;
import net.minecraft.class_3866;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@ApiStatus.Internal
public class ShulkerBoxTooltip
implements ShulkerBoxTooltipApi {
    public static final String MOD_ID = "shulkerboxtooltip";
    public static final String MOD_NAME = "ShulkerBoxTooltip";
    public static final NamedLogger LOGGER = new NamedLogger(LogManager.getFormatterLogger((String)"ShulkerBoxTooltip"));
    public static Configuration config;
    public static Configuration savedConfig;

    public static void init() {
        savedConfig = ConfigurationHandler.register();
        config = ConfigurationHandler.copyOf(savedConfig);
        ServerNetworking.init();
    }

    private static void register(PreviewProviderRegistry registry, String id, PreviewProvider provider, class_1792 ... items) {
        registry.register(ShulkerBoxTooltipUtil.id(id), provider, items);
    }

    private static <BE extends class_2586> void register(PreviewProviderRegistry registry, String id, int maxRowSize, BiFunction<Integer, Supplier<BE>, PreviewProvider> providerFactory, BiFunction<class_2338, class_2680, BE> blockEntityFactory, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            PreviewProvider provider = providerFactory.apply(maxRowSize, () -> (class_2586)blockEntityFactory.apply(class_2338.field_10980, block.method_9564()));
            registry.register(ShulkerBoxTooltipUtil.id(id), provider, block.method_8389());
        }
    }

    @Override
    public void registerProviders(PreviewProviderRegistry registry) {
        ShulkerBoxTooltip.register(registry, "shulker_box", 9, ShulkerBoxPreviewProvider::new, class_2627::new, class_2246.field_10603, class_2246.field_10199, class_2246.field_10407, class_2246.field_10063, class_2246.field_10203, class_2246.field_10600, class_2246.field_10275, class_2246.field_10051, class_2246.field_10140, class_2246.field_10320, class_2246.field_10532, class_2246.field_10268, class_2246.field_10605, class_2246.field_10373, class_2246.field_10055, class_2246.field_10068, class_2246.field_10371);
        ShulkerBoxTooltip.register(registry, "chest_like", 9, BlockEntityAwarePreviewRenderer::new, class_2595::new, class_2246.field_10034, class_2246.field_10380, class_2246.field_16328);
        ShulkerBoxTooltip.register(registry, "furnace_like", 3, BlockEntityAwarePreviewRenderer::new, class_3866::new, class_2246.field_10181);
        ShulkerBoxTooltip.register(registry, "furnace_like", 3, BlockEntityAwarePreviewRenderer::new, class_3720::new, class_2246.field_16333);
        ShulkerBoxTooltip.register(registry, "furnace_like", 3, BlockEntityAwarePreviewRenderer::new, class_3723::new, class_2246.field_16334);
        ShulkerBoxTooltip.register(registry, "dropper_like", 9, BlockEntityAwarePreviewRenderer::new, class_2608::new, class_2246.field_10228);
        ShulkerBoxTooltip.register(registry, "dropper_like", 9, BlockEntityAwarePreviewRenderer::new, class_2601::new, class_2246.field_10200);
        ShulkerBoxTooltip.register(registry, "hopper", 5, BlockEntityAwarePreviewRenderer::new, class_2589::new, class_2246.field_10312);
        ShulkerBoxTooltip.register(registry, "brewing_stand", 5, BlockEntityAwarePreviewRenderer::new, class_2589::new, class_2246.field_10333);
        ShulkerBoxTooltip.register(registry, "ender_chest", new EnderChestPreviewProvider(), class_1802.field_8466);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerColors(ColorRegistry registry) {
        registry.defaultCategory().register(ColorKey.DEFAULT, "default").register(ColorKey.ENDER_CHEST, "ender_chest", ShulkerBoxTooltip.blockName("ender_chest"));
        registry.category(ShulkerBoxTooltipUtil.id("shulker_boxes")).register(ColorKey.SHULKER_BOX, "shulker_box", ShulkerBoxTooltip.blockName("shulker_box")).register(ColorKey.WHITE_SHULKER_BOX, "white_shulker_box", ShulkerBoxTooltip.blockName("white_shulker_box")).register(ColorKey.ORANGE_SHULKER_BOX, "orange_shulker_box", ShulkerBoxTooltip.blockName("orange_shulker_box")).register(ColorKey.MAGENTA_SHULKER_BOX, "magenta_shulker_box", ShulkerBoxTooltip.blockName("magenta_shulker_box")).register(ColorKey.LIGHT_BLUE_SHULKER_BOX, "light_blue_shulker_box", ShulkerBoxTooltip.blockName("light_blue_shulker_box")).register(ColorKey.YELLOW_SHULKER_BOX, "yellow_shulker_box", ShulkerBoxTooltip.blockName("yellow_shulker_box")).register(ColorKey.LIME_SHULKER_BOX, "lime_shulker_box", ShulkerBoxTooltip.blockName("lime_shulker_box")).register(ColorKey.PINK_SHULKER_BOX, "pink_shulker_box", ShulkerBoxTooltip.blockName("pink_shulker_box")).register(ColorKey.GRAY_SHULKER_BOX, "gray_shulker_box", ShulkerBoxTooltip.blockName("gray_shulker_box")).register(ColorKey.LIGHT_GRAY_SHULKER_BOX, "light_gray_shulker_box", ShulkerBoxTooltip.blockName("light_gray_shulker_box")).register(ColorKey.CYAN_SHULKER_BOX, "cyan_shulker_box", ShulkerBoxTooltip.blockName("cyan_shulker_box")).register(ColorKey.PURPLE_SHULKER_BOX, "purple_shulker_box", ShulkerBoxTooltip.blockName("purple_shulker_box")).register(ColorKey.BLUE_SHULKER_BOX, "blue_shulker_box", ShulkerBoxTooltip.blockName("blue_shulker_box")).register(ColorKey.BROWN_SHULKER_BOX, "brown_shulker_box", ShulkerBoxTooltip.blockName("brown_shulker_box")).register(ColorKey.GREEN_SHULKER_BOX, "green_shulker_box", ShulkerBoxTooltip.blockName("green_shulker_box")).register(ColorKey.RED_SHULKER_BOX, "red_shulker_box", ShulkerBoxTooltip.blockName("red_shulker_box")).register(ColorKey.BLACK_SHULKER_BOX, "black_shulker_box", ShulkerBoxTooltip.blockName("black_shulker_box"));
    }

    private static String blockName(String block) {
        return "block.minecraft." + block;
    }

    @ExpectPlatform
    @Contract(value="-> _", pure=true)
    @ExpectPlatform.Transformed
    public static boolean isClient() {
        return ShulkerBoxTooltipImpl.isClient();
    }

    @ExpectPlatform
    @Contract(value="-> _", pure=true)
    @ExpectPlatform.Transformed
    public static Path getConfigDir() {
        return ShulkerBoxTooltipImpl.getConfigDir();
    }
}

