/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.trades;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.moonlight.api.trades.RemoveNonDataListingListing;
import net.mehvahdjukaar.moonlight.api.trades.SimpleItemListing;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1914;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_4309;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ItemListingRegistry
extends class_4309 {
    public static final ItemListingRegistry INSTANCE = new ItemListingRegistry();
    private final BiMap<class_2960, Codec<ModItemListing>> serializers = HashBiMap.create();
    private final Map<class_1299<?>, Int2ObjectArrayMap<List<ModItemListing>>> specialCustomTrades = new HashMap();
    private final Map<class_3852, Int2ObjectArrayMap<List<ModItemListing>>> customTrades = new HashMap<class_3852, Int2ObjectArrayMap<List<ModItemListing>>>();
    private final Map<class_1299<?>, Int2ObjectArrayMap<ModItemListing[]>> oldSpecialTrades = new HashMap();
    private final Map<class_3852, Int2ObjectArrayMap<ModItemListing[]>> oldTrades = new HashMap<class_3852, Int2ObjectArrayMap<ModItemListing[]>>();
    private int count = 0;

    public ItemListingRegistry() {
        super(new Gson(), "moonlight/villager_trades");
        this.serializers.put((Object)new class_2960("simple"), SimpleItemListing.CODEC);
        this.serializers.put((Object)new class_2960("remove_all_non_data"), RemoveNonDataListingListing.CODEC);
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        this.mergeProfessionAndSpecial(false);
        this.count = 0;
        this.customTrades.clear();
        this.specialCustomTrades.clear();
        for (Map.Entry<class_2960, JsonElement> e : jsons.entrySet()) {
            JsonElement j = e.getValue();
            class_2960 id = e.getKey();
            try {
                if (!id.method_12832().contains("/")) continue;
                class_2960 targetId = id.method_45134(p -> p.substring(0, p.lastIndexOf(47)));
                Optional profession = class_7923.field_41195.method_17966(targetId);
                if (profession.isPresent()) {
                    ModItemListing trade = ItemListingRegistry.parseOrThrow(j, id);
                    ((List)this.customTrades.computeIfAbsent((class_3852)profession.get(), t -> new Int2ObjectArrayMap()).computeIfAbsent(trade.getLevel(), a -> new ArrayList())).add(trade);
                    continue;
                }
                Optional entityType = class_7923.field_41177.method_17966(targetId);
                if (entityType.isPresent()) {
                    ModItemListing trade = ItemListingRegistry.parseOrThrow(j, id);
                    ((List)this.specialCustomTrades.computeIfAbsent((class_1299)entityType.get(), t -> new Int2ObjectArrayMap()).computeIfAbsent(trade.getLevel(), a -> new ArrayList())).add(trade);
                    continue;
                }
                Moonlight.LOGGER.warn("Unknown villager type: {}", (Object)targetId);
            }
            catch (Exception err) {
                Moonlight.LOGGER.error("Something went wrong while parsing custom villager trades", (Throwable)err);
            }
        }
        this.mergeProfessionAndSpecial(true);
        if (this.count != 0) {
            Moonlight.LOGGER.info("Applied {} data villager trades", (Object)this.count);
        }
    }

    private void mergeAll(Int2ObjectMap<class_3853.class_1652[]> originalValues, Int2ObjectArrayMap<List<ModItemListing>> newValues, boolean add) {
        for (Int2ObjectMap.Entry e : newValues.int2ObjectEntrySet()) {
            int level = e.getIntKey();
            class_3853.class_1652[] elements = (class_3853.class_1652[])originalValues.get(level);
            ArrayList original = new ArrayList(elements == null ? List.of() : List.of(elements));
            List value = (List)e.getValue();
            if (add) {
                original.addAll(value);
                this.count += value.size();
            } else {
                original.removeAll(value);
            }
            originalValues.put(level, (Object)((class_3853.class_1652[])original.toArray(class_3853.class_1652[]::new)));
        }
    }

    private void mergeProfessionAndSpecial(boolean add) {
        for (Map.Entry<class_3852, Int2ObjectArrayMap<List<ModItemListing>>> p : this.customTrades.entrySet()) {
            class_3852 profession = p.getKey();
            Int2ObjectMap map = class_3853.field_17067.computeIfAbsent(profession, k -> new Int2ObjectArrayMap());
            Int2ObjectArrayMap<List<ModItemListing>> value = p.getValue();
            this.mergeAll((Int2ObjectMap<class_3853.class_1652[]>)map, value, add);
        }
        Int2ObjectArrayMap<List<ModItemListing>> wanderingStuff = this.specialCustomTrades.get(class_1299.field_17713);
        if (wanderingStuff != null) {
            this.mergeAll((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17724, wanderingStuff, add);
        }
    }

    private static ModItemListing parseOrThrow(JsonElement j, class_2960 id) {
        return (ModItemListing)((Pair)ModItemListing.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)j).getOrThrow(false, errorMsg -> Moonlight.LOGGER.warn("Failed to parse custom trade with id {} - error: {}", (Object)id, errorMsg))).getFirst();
    }

    public static List<? extends class_3853.class_1652> getVillagerListings(class_3852 profession, int level) {
        class_3853.class_1652[] array = (class_3853.class_1652[])((Int2ObjectMap)class_3853.field_17067.get(profession)).get(level);
        if (array == null) {
            return List.of();
        }
        return Arrays.stream(array).toList();
    }

    public static List<? extends class_3853.class_1652> getSpecialListings(class_1299<?> entityType, int level) {
        if (entityType == class_1299.field_17713) {
            class_3853.class_1652[] array = (class_3853.class_1652[])class_3853.field_17724.get(level);
            if (array == null) {
                return List.of();
            }
            return Arrays.stream(array).toList();
        }
        Int2ObjectArrayMap<List<ModItemListing>> special = ItemListingRegistry.INSTANCE.specialCustomTrades.get(entityType);
        if (special == null) {
            return List.of();
        }
        return (List)special.getOrDefault(level, List.of());
    }

    public static void registerSerializer(class_2960 id, Codec<? extends ModItemListing> trade) {
        ItemListingRegistry.INSTANCE.serializers.put((Object)id, trade);
    }

    public static void registerSimple(class_2960 id, class_3853.class_1652 instance, int level) {
        SpecialListing specialListing = new SpecialListing(instance, level);
        ItemListingRegistry.registerSerializer(id, specialListing.getCodec());
    }

    public static Codec<ModItemListing> getSerializer(class_2960 id) {
        return (Codec)ItemListingRegistry.INSTANCE.serializers.get((Object)id);
    }

    public static class_2960 getSerializerKey(Codec<ModItemListing> object) {
        return (class_2960)ItemListingRegistry.INSTANCE.serializers.inverse().get(object);
    }

    private static class SpecialListing
    implements ModItemListing {
        private final Codec<ModItemListing> codec = Codec.unit((Object)this);
        private final class_3853.class_1652 listing;
        private final int level;

        public SpecialListing(class_3853.class_1652 listing, int level) {
            this.listing = listing;
            this.level = level;
        }

        @Override
        public Codec<? extends ModItemListing> getCodec() {
            return this.codec;
        }

        @Nullable
        public class_1914 method_7246(class_1297 trader, class_5819 random) {
            return this.listing.method_7246(trader, random);
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

