/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WoodTypeRegistry
extends BlockTypeRegistry<WoodType> {
    public static final WoodType OAK_TYPE = new WoodType(new class_2960("oak"), class_2246.field_10161, class_2246.field_10431);
    public static final WoodTypeRegistry INSTANCE = new WoodTypeRegistry();
    Map<class_4719, WoodType> fromVanilla = new IdentityHashMap<class_4719, WoodType>();
    public static Set<String> IGNORED_MODS = new HashSet<String>(Set.of("chipped", "securitycraft", "absentbydesign"));
    private static final List<class_4719> VANILLA_ORDER = List.of(class_4719.field_21676, class_4719.field_21677, class_4719.field_21678, class_4719.field_21680, class_4719.field_21679, class_4719.field_21681, class_4719.field_37657, class_4719.field_42837, class_4719.field_40350, class_4719.field_22183, class_4719.field_22184);

    public static Collection<WoodType> getTypes() {
        return INSTANCE.getValues();
    }

    @Nullable
    public static WoodType getValue(class_2960 name) {
        return (WoodType)INSTANCE.get(name);
    }

    public static WoodType fromNBT(String name) {
        return (WoodType)INSTANCE.getFromNBT(name);
    }

    public static WoodType fromVanilla(class_4719 vanillaType) {
        return INSTANCE.getFromVanilla(vanillaType);
    }

    public WoodTypeRegistry() {
        super(WoodType.class, "wood_type");
        this.addFinder(() -> {
            WoodType b = new WoodType(new class_2960("bamboo"), class_2246.field_40294, class_2246.field_41072);
            b.addChild("stripped_log", class_2246.field_41073);
            return Optional.of(b);
        });
    }

    @Override
    public WoodType getDefaultType() {
        return OAK_TYPE;
    }

    @Override
    public Optional<WoodType> detectTypeFromBlock(class_2248 baseBlock, class_2960 baseRes) {
        class_2680 state;
        String name = null;
        String path = baseRes.method_12832();
        if (baseRes.method_12836().equals("tfc") || baseRes.method_12836().equals("afc")) {
            Optional log;
            if (path.contains("wood/planks/") && (log = class_7923.field_41175.method_17966(new class_2960(baseRes.method_12836(), path.replace("planks", "log")))).isPresent()) {
                class_2960 id = new class_2960(baseRes.method_12836(), path.replace("wood/planks/", ""));
                return Optional.of(new WoodType(id, baseBlock, (class_2248)log.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        String namespace = baseRes.method_12836();
        if (name != null && !IGNORED_MODS.contains(namespace) && (state = baseBlock.method_9564()).method_28501().size() <= 2 && !(baseBlock instanceof class_2482)) {
            name = name.replace("/", "_");
            class_2960 id = new class_2960(baseRes.method_12836(), name);
            class_2248 logBlock = WoodTypeRegistry.findLog(id);
            if (logBlock != null) {
                if (state.method_51364() != class_2766.field_12651) {
                    Moonlight.LOGGER.error("Found wood type candidate with plank {} having incorrect noteblock sound type! This is likely due to some mod not having updated correctly (.material(WOOD) to .noteBlockSound(BASS) ). This should be corrected! Proceeding anyways", (Object)baseRes);
                }
                return Optional.of(new WoodType(id, baseBlock, logBlock));
            }
        }
        return Optional.empty();
    }

    @Nullable
    private static class_2248 findLog(class_2960 id) {
        List<String> keywords = List.of("log", "stem", "stalk", "hyphae");
        ArrayList<class_2960> resources = new ArrayList<class_2960>();
        for (String keyword : keywords) {
            resources.add(new class_2960(id.method_12836(), id.method_12832() + "_" + keyword));
            resources.add(new class_2960(id.method_12836(), keyword + "_" + id.method_12832()));
            resources.add(new class_2960(id.method_12832() + "_" + keyword));
            resources.add(new class_2960(keyword + "_" + id.method_12832()));
        }
        class_2960[] test = resources.toArray(new class_2960[0]);
        class_2248 temp = null;
        for (class_2960 r : test) {
            if (!class_7923.field_41175.method_10250(r)) continue;
            temp = (class_2248)class_7923.field_41175.method_10223(r);
            break;
        }
        return temp;
    }

    @Override
    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(w -> {
            if (language.isDefault()) {
                language.addEntry(w.getTranslationKey(), w.getReadableName());
            }
        });
    }

    @Nullable
    public WoodType getFromVanilla(class_4719 woodType) {
        return this.fromVanilla.get(woodType);
    }

    void mapVanillaWood(WoodType woodType) {
        class_4719 v = woodType.toVanilla();
        if (v != null) {
            this.fromVanilla.put(v, woodType);
        }
    }

    @Override
    protected void finalizeAndFreeze() {
        ArrayList temp = new ArrayList(this.builder);
        this.builder.clear();
        block0: for (class_4719 v : VANILLA_ORDER) {
            for (WoodType t : temp) {
                if (t.toVanilla() != v) continue;
                this.builder.add(t);
                temp.remove(t);
                continue block0;
            }
        }
        this.builder.addAll(temp);
        super.finalizeAndFreeze();
    }
}

