/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import org.jetbrains.annotations.Nullable;

public class RecipeConverter {
    private static final Map<Class<?>, RecipeConverter> CONVERTERS = new HashMap();
    private List<Field> fieldToConvert = new ArrayList<Field>();

    private RecipeConverter(List<Field> fields) {
        this.fieldToConvert = fields;
    }

    @Nullable
    private <R, T extends BlockType> R convert(R recipe, T originalMat, T destinationMat, class_1792 unlockedBy, String id) throws IllegalAccessException {
        for (Field f : this.fieldToConvert) {
            Object value = f.get(recipe);
            if (value instanceof List) {
                List list = (List)value;
                boolean oneChanged = false;
                ListIterator iterator = list.listIterator();
                while (iterator.hasNext()) {
                    Object currentValue = iterator.next();
                    Object newValue = this.tryConverting(originalMat, destinationMat, currentValue);
                    if (newValue == null) continue;
                    oneChanged = true;
                    iterator.set(newValue);
                }
                if (oneChanged) continue;
                throw new RuntimeException(String.format("Failed to convert some fields for recipe %s from type %s to type %s", recipe, originalMat, destinationMat));
            }
            if (value instanceof Map) {
                Map map;
                Map omap = map = (Map)value;
                boolean oneChanged = false;
                for (Map.Entry entry : new HashSet(omap.entrySet())) {
                    Object currentKey = entry.getKey();
                    Object currentValue = entry.getValue();
                    Object newKey = this.tryConverting(originalMat, destinationMat, currentKey);
                    Object newValue = this.tryConverting(originalMat, destinationMat, currentValue);
                    if (newKey != null || newValue != null) {
                        omap.remove(currentKey);
                        oneChanged = true;
                    }
                    if (newKey != null) {
                        omap.put(newKey, newValue != null ? newValue : currentValue);
                        continue;
                    }
                    if (newValue == null) continue;
                    entry.setValue(newValue);
                }
                if (oneChanged) continue;
                throw new RuntimeException(String.format("Failed to convert some fields for recipe %s from type %s to type %s", recipe, originalMat, destinationMat));
            }
            if (value instanceof Record) {
                RecipeConverter innerConv = RecipeConverter.getOrCreateConverter(value.getClass());
                if (innerConv == null) continue;
                innerConv.convert(value, originalMat, destinationMat, unlockedBy, id);
                continue;
            }
            if (value instanceof Optional) {
                RecipeConverter innerConv;
                Optional opt = (Optional)value;
                if (!opt.isPresent() || (innerConv = RecipeConverter.getOrCreateConverter((value = opt.get()).getClass())) == null) continue;
                f.setAccessible(true);
                f.set(recipe, Optional.of(innerConv.convert(value, originalMat, destinationMat, unlockedBy, id)));
                continue;
            }
            Object newValue = this.tryConverting(originalMat, destinationMat, value);
            if (newValue == null) {
                throw new RuntimeException(String.format("Failed to convert item %s for recipe %s from type %s to type %s", value, recipe, originalMat, destinationMat));
            }
            f.set(recipe, newValue);
        }
        return recipe;
    }

    @Nullable
    private <V, T extends BlockType> V tryConverting(T originalMat, T destinationMat, V value) {
        if (value instanceof class_1799) {
            class_1799 stack = (class_1799)value;
            class_1792 item = BlockType.changeItemType(stack.method_7909(), originalMat, destinationMat);
            if (item == null) {
                return null;
            }
            return (V)item.method_7854();
        }
        if (value instanceof class_1792) {
            class_1792 il = (class_1792)value;
            return (V)BlockType.changeItemType(il, originalMat, destinationMat);
        }
        if (value instanceof class_1856) {
            class_1856 ing = (class_1856)value;
            return (V)this.convertIngredients(originalMat, destinationMat, ing);
        }
        return null;
    }

    @Nullable
    private <T extends BlockType> class_1856 convertIngredients(T originalMat, T destinationMat, class_1856 ing) {
        for (class_1799 in : ing.method_8105()) {
            class_1792 i;
            class_1792 it = in.method_7909();
            if (it == class_1802.field_8077 || (i = BlockType.changeItemType(it, originalMat, destinationMat)) == null) continue;
            return class_1856.method_8091((class_1935[])new class_1935[]{i});
        }
        return null;
    }

    @Nullable
    public static <T extends BlockType, R extends class_1860<?>> R createSimilar(R recipe, T originalMat, T destinationMat, class_1792 unlockItem, @Nullable String id) {
        Class<?> clazz = (recipe = RPUtils.readRecipe(RPUtils.writeRecipe(recipe))).getClass();
        RecipeConverter conv = RecipeConverter.getOrCreateConverter(clazz);
        if (conv == null) {
            throw new RuntimeException("Failed to convert recipe of class " + clazz);
        }
        try {
            return (R)((class_1860)conv.convert(recipe, originalMat, destinationMat, unlockItem, id));
        }
        catch (Exception e) {
            Moonlight.LOGGER.error("Recipe conversion error: " + e.getMessage());
            return null;
        }
    }

    @Nullable
    private static RecipeConverter getOrCreateConverter(Class<?> clazz) {
        return CONVERTERS.computeIfAbsent(clazz, c -> {
            try {
                List<Field> fields = RecipeConverter.findFieldsByType(clazz, class_1799.class, class_1792.class, class_1856.class, Record.class);
                fields.forEach(f -> f.setAccessible(true));
                return new RecipeConverter(fields);
            }
            catch (Exception exception) {
                return null;
            }
        });
    }

    private static List<Field> findFieldsByType(Class<?> clazz, Class<?> ... targetTypes) {
        ArrayList<Field> foundFields = new ArrayList<Field>();
        block0: for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            for (Class<?> targetType : targetTypes) {
                if (targetType.isAssignableFrom(fieldType)) {
                    foundFields.add(field);
                    continue block0;
                }
                if (List.class.isAssignableFrom(fieldType)) {
                    ParameterizedType listType = (ParameterizedType)field.getGenericType();
                    Class listElementType = (Class)listType.getActualTypeArguments()[0];
                    if (!listElementType.equals(targetType)) continue;
                    foundFields.add(field);
                    continue block0;
                }
                if (!Map.class.isAssignableFrom(fieldType)) continue;
                ParameterizedType mapType = (ParameterizedType)field.getGenericType();
                Class mapKeyType = (Class)mapType.getActualTypeArguments()[0];
                Class mapValueType = (Class)mapType.getActualTypeArguments()[1];
                if (!targetType.isAssignableFrom(mapKeyType) && !targetType.isAssignableFrom(mapValueType)) continue;
                foundFields.add(field);
                continue block0;
            }
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            foundFields.addAll(RecipeConverter.findFieldsByType(superClass, targetTypes));
        }
        return foundFields;
    }
}

