/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.network.fabric;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.fabric.FabricClientNetwork;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class NetworkHelperImpl {
    protected static final Map<Class<?>, class_2960> ID_MAP = new ConcurrentHashMap();

    public static void addRegistration(final String modId, Consumer<NetworkHelper.RegEvent> eventConsumer) {
        eventConsumer.accept(new NetworkHelper.RegEvent(){
            int idCount = 0;

            @Override
            public NetworkHelper.RegEvent setVersion(int version) {
                return this;
            }

            @Override
            public <M extends Message> NetworkHelper.RegEvent register(NetworkDir direction, Class<M> messageClass, Function<class_2540, M> decoder) {
                class_2960 res = new class_2960(modId, String.valueOf(this.idCount++));
                NetworkHelperImpl.registerId(res, messageClass);
                if (direction != NetworkDir.CLIENTBOUND) {
                    ServerPlayNetworking.registerGlobalReceiver((class_2960)res, (server, player, h, buf, r) -> {
                        Message message = (Message)decoder.apply(buf);
                        server.execute(() -> message.handle(new Wrapper((class_1657)player, NetworkDir.SERVERBOUND, h)));
                    });
                }
                if (direction != NetworkDir.SERVERBOUND && PlatHelper.getPhysicalSide().isClient()) {
                    FabricClientNetwork.register(res, decoder);
                }
                return this;
            }
        });
    }

    private static <M extends Message> void registerId(class_2960 id, Class<M> clazz) {
        try {
            ID_MAP.put(clazz, id);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't register multiple payloads with same class " + clazz);
        }
    }

    private static class_2596<?> toVanilla(Message message) {
        class_2540 buf = PacketByteBufs.create();
        message.write(buf);
        return ServerPlayNetworking.createS2CPacket((class_2960)ID_MAP.get(message.getClass()), (class_2540)buf);
    }

    public static void sendToClientPlayer(class_3222 serverPlayer, Message message) {
        class_2540 buf = PacketByteBufs.create();
        message.write(buf);
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)ID_MAP.get(message.getClass()), (class_2540)buf);
    }

    public static void sendToAllClientPlayers(Message message) {
        for (class_3222 p : PlatHelper.getCurrentServer().method_3760().method_14571()) {
            NetworkHelperImpl.sendToClientPlayer(p, message);
        }
    }

    public static void sendToServer(Message message) {
        class_2540 buf = PacketByteBufs.create();
        message.write(buf);
        ClientPlayNetworking.send((class_2960)ID_MAP.get(message.getClass()), (class_2540)buf);
    }

    public static void sendToAllClientPlayersInRange(class_1937 level, class_2338 pos, double radius, Message message) {
        MinecraftServer currentServer = PlatHelper.getCurrentServer();
        if (!level.field_9236 && currentServer != null) {
            class_3324 players = currentServer.method_3760();
            class_5321 dimension = level.method_27983();
            players.method_14605(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), radius, dimension, NetworkHelperImpl.toVanilla(message));
        } else if (PlatHelper.isDev()) {
            throw new AssertionError((Object)"Cant send message to clients from client side");
        }
    }

    public static void sentToAllClientPlayersTrackingEntity(class_1297 target, Message message) {
        class_1937 class_19372 = target.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14178().method_18754(target, NetworkHelperImpl.toVanilla(message));
        } else if (PlatHelper.isDev()) {
            throw new AssertionError((Object)"Cant send message to clients from client side");
        }
    }

    public static void sentToAllClientPlayersTrackingEntityAndSelf(class_1297 target, Message message) {
        class_1937 class_19372 = target.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14178().method_18754(target, NetworkHelperImpl.toVanilla(message));
            if (target instanceof class_3222) {
                class_3222 player = (class_3222)target;
                NetworkHelperImpl.sendToClientPlayer(player, message);
            }
        } else if (PlatHelper.isDev()) {
            throw new AssertionError((Object)"Cant send message to clients from client side");
        }
    }

    static class Wrapper
    implements NetworkHelper.Context {
        private final class_1657 player;
        private final NetworkDir dir;
        @Nullable
        private final class_3244 packetListener;

        public Wrapper(class_1657 player, NetworkDir dir, class_3244 packetListener) {
            this.player = player;
            this.dir = dir;
            this.packetListener = packetListener;
        }

        @Override
        public NetworkDir getDirection() {
            return this.dir;
        }

        @Override
        public class_1657 getSender() {
            return this.player;
        }

        @Override
        public void disconnect(class_2561 reason) {
            if (this.packetListener != null) {
                this.packetListener.method_52396(reason);
            } else if (PlatHelper.isDev()) {
                throw new AssertionError((Object)"Cant disconnect on client");
            }
        }
    }
}

