/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import java.util.Arrays;
import net.mehvahdjukaar.moonlight.api.integration.MapAtlasCompat;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class MapHelper {
    @Nullable
    public static class_22 getMapData(class_1799 stack, class_1937 level, @Nullable class_1657 player) {
        class_22 data = class_1806.method_8001((class_1799)stack, (class_1937)level);
        if (data == null && CompatHandler.MAP_ATLASES && player != null) {
            data = MapAtlasCompat.getSavedDataFromAtlas(stack, level, player);
        }
        return data;
    }

    public static void addVanillaDecorations(class_1799 stack, class_2338 pos, class_20.class_21 type, int mapColor) {
        class_22.method_110((class_1799)stack, (class_2338)pos, (String)"+", (class_20.class_21)type);
        if (mapColor != 0) {
            class_2487 com = stack.method_7911("display");
            com.method_10569("MapColor", mapColor);
        }
    }

    public static void addDecorationToStack(class_1799 stack, class_2338 pos, MapDecorationType<?, ?> type, int mapColor) {
        class_2499 tags;
        if (stack.method_7985() && stack.method_7969().method_10573("CustomDecorations", 9)) {
            tags = stack.method_7969().method_10554("CustomDecorations", 10);
        } else {
            tags = new class_2499();
            stack.method_7959("CustomDecorations", (class_2520)tags);
        }
        class_2487 tag = new class_2487();
        tag.method_10582("type", Utils.getID(type).toString());
        tag.method_10569("x", pos.method_10263());
        tag.method_10569("z", pos.method_10260());
        tags.add((Object)tag);
        if (mapColor != 0) {
            class_2487 com = stack.method_7911("display");
            com.method_10569("MapColor", mapColor);
        }
    }

    public static void addDecorationToStack(class_1799 stack, class_2338 pos, class_2960 id, int mapColor) {
        Object type;
        if (id.method_12836().equals("minecraft") && (type = MapHelper.getVanillaType(id)) != null) {
            MapHelper.addVanillaDecorations(stack, pos, type, mapColor);
            return;
        }
        type = MapDataRegistry.get(id);
        if (type != null) {
            MapHelper.addDecorationToStack(stack, pos, type, mapColor);
        } else {
            MapHelper.addVanillaDecorations(stack, pos, class_20.class_21.field_84, mapColor);
        }
    }

    @Nullable
    private static class_20.class_21 getVanillaType(class_2960 id) {
        return Arrays.stream(class_20.class_21.values()).filter(t -> t.toString().toLowerCase().equals(id.method_12832())).findFirst().orElse(null);
    }

    public static boolean toggleMarkersAtPos(class_1937 level, class_2338 pos, class_1799 stack, @Nullable class_1657 player) {
        class_22 data = MapHelper.getMapData(stack, level, player);
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            return expandedMapData.toggleCustomDecoration((class_1936)level, pos);
        }
        return false;
    }

    public static boolean removeAllCustomMarkers(class_1937 level, class_1799 stack, @Nullable class_1657 player) {
        class_22 data = MapHelper.getMapData(stack, level, player);
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            if (!level.field_9236) {
                expandedMapData.resetCustomDecoration();
                return true;
            }
        }
        return false;
    }

    public static boolean addPersistentDecoration(class_22 data, class_1937 level, class_2960 id, class_2338 pos, @Nullable class_2561 name) {
        MapDecorationType<?, ?> type = MapDataRegistry.get(id);
        if (type != null) {
            Object marker = type.createEmptyMarker();
            ((MapBlockMarker)marker).setPersistent(true);
            ((MapBlockMarker)marker).setPos(pos);
            ((MapBlockMarker)marker).setName(name);
            ((ExpandedMapData)data).addCustomMarker(marker);
            return true;
        }
        return false;
    }
}

