/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.SoftFluidImpl;
import net.mehvahdjukaar.moonlight.api.misc.Triplet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.core.StrOpt;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5381;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SoftFluid {
    private final class_2960 stillTexture;
    private final class_2960 flowingTexture;
    private final String fromMod;
    private final String translationKey;
    private final int luminosity;
    private final int tintColor;
    private final TintMethod tintMethod;
    private final List<class_3611> equivalentFluids;
    private final FluidContainerList containerList;
    private final FoodProvider food;
    private final List<String> NBTFromItem;
    @Nullable
    private final class_2960 useTexturesFrom;
    public final boolean isGenerated;
    public static final int BOTTLE_COUNT = 1;
    public static final int BOWL_COUNT = 2;
    public static final int BUCKET_COUNT = 4;
    public static final Codec<class_6880<SoftFluid>> HOLDER_CODEC = class_5381.method_29749(SoftFluidRegistry.KEY, CODEC);
    public static final Codec<SoftFluid> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("still_texture").forGetter(SoftFluid::getStillTexture), (App)class_2960.field_25139.fieldOf("flowing_texture").forGetter(SoftFluid::getFlowingTexture), (App)StrOpt.of(Codec.STRING, "from_mod").forGetter(SoftFluid.getHackyOptional(SoftFluid::getFromMod)), (App)StrOpt.of(Codec.STRING, "translation_key").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTranslationKey)), (App)StrOpt.of(Codec.intRange((int)0, (int)15), "luminosity").forGetter(SoftFluid.getHackyOptional(SoftFluid::getLuminosity)), (App)StrOpt.of(ColorUtils.CODEC, "color").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTintColor)), (App)StrOpt.of(TintMethod.CODEC, "tint_method").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTintMethod)), (App)FoodProvider.CODEC.optionalFieldOf("food").forGetter(SoftFluid.getHackyOptional(SoftFluid::getFoodProvider)), (App)StrOpt.of(Codec.STRING.listOf(), "preserved_tags_from_item").forGetter(SoftFluid.getHackyOptional(SoftFluid::getNbtKeyFromItem)), (App)StrOpt.of(FluidContainerList.Category.CODEC.listOf(), "containers").forGetter(f -> f.getContainerList().encodeList()), (App)class_7923.field_41173.method_39673().listOf().optionalFieldOf("equivalent_fluids").forGetter(SoftFluid.getHackyOptional(s -> s.getEquivalentFluids().stream().toList())), (App)StrOpt.of(class_2960.field_25139, "use_texture_from").forGetter(s -> Optional.ofNullable(s.getTextureOverride()))).apply((Applicative)instance, SoftFluid::create));
    private static final SoftFluid DEFAULT_DUMMY = new SoftFluid(new Builder(new class_2960(""), new class_2960("")));

    private SoftFluid(Builder builder) {
        Triplet<class_2960, class_2960, Integer> data;
        this.tintMethod = builder.tintMethod;
        this.equivalentFluids = builder.equivalentFluids;
        this.luminosity = builder.luminosity;
        this.containerList = builder.containerList;
        this.food = builder.food;
        this.fromMod = builder.fromMod;
        this.translationKey = builder.translationKey;
        this.NBTFromItem = builder.NBTFromItem;
        this.useTexturesFrom = builder.useTexturesFrom;
        class_2960 still = builder.stillTexture;
        class_2960 flowing = builder.flowingTexture;
        int tint = builder.tintColor;
        if (this.useTexturesFrom != null && (data = SoftFluid.getRenderingData(this.useTexturesFrom)) != null) {
            still = data.left();
            flowing = data.middle();
            tint = data.right();
        }
        this.stillTexture = still;
        this.flowingTexture = flowing;
        this.tintColor = tint;
        this.isGenerated = builder.isFromData;
    }

    @Nullable
    public class_2960 getTextureOverride() {
        return this.useTexturesFrom;
    }

    public FoodProvider getFoodProvider() {
        return this.food;
    }

    public class_2561 getTranslatedName() {
        return class_2561.method_43471((String)this.translationKey);
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public String getFromMod() {
        return this.fromMod;
    }

    public class_3611 getVanillaFluid() {
        Iterator<class_3611> iterator = this.getEquivalentFluids().iterator();
        if (iterator.hasNext()) {
            class_3611 fluid = iterator.next();
            return fluid;
        }
        return class_3612.field_15906;
    }

    public List<String> getNbtKeyFromItem() {
        return this.NBTFromItem;
    }

    public List<class_3611> getEquivalentFluids() {
        return this.equivalentFluids;
    }

    public boolean isEquivalent(class_3611 fluid) {
        return this.equivalentFluids.contains(fluid);
    }

    public boolean isEmpty() {
        return this == SoftFluidRegistry.getEmpty();
    }

    public Optional<class_1792> getFilledContainer(class_1792 emptyContainer) {
        return this.containerList.getFilled(emptyContainer);
    }

    public Optional<class_1792> getEmptyContainer(class_1792 filledContainer) {
        return this.containerList.getEmpty(filledContainer);
    }

    public FluidContainerList getContainerList() {
        return this.containerList;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public TintMethod getTintMethod() {
        return this.tintMethod;
    }

    public boolean isColored() {
        return this.tintColor != -1;
    }

    public class_2960 getFlowingTexture() {
        return this.flowingTexture;
    }

    public class_2960 getStillTexture() {
        return this.stillTexture;
    }

    public boolean isFood() {
        return !this.food.isEmpty();
    }

    protected static SoftFluid create(class_2960 still, class_2960 flowing, Optional<String> fromMod, Optional<String> translation, Optional<Integer> luminosity, Optional<Integer> color, Optional<TintMethod> tint, Optional<FoodProvider> food, Optional<List<String>> nbtKeys, Optional<List<FluidContainerList.Category>> containers, Optional<List<class_3611>> equivalent, Optional<class_2960> textureFrom) {
        Builder builder = new Builder(still, flowing);
        fromMod.ifPresent(builder::fromMod);
        translation.ifPresent(builder::translationKey);
        luminosity.ifPresent(builder::luminosity);
        color.ifPresent(builder::color);
        tint.ifPresent(builder::tintMethod);
        food.ifPresent(builder::food);
        nbtKeys.ifPresent(k -> k.forEach(xva$0 -> builder.keepNBTFromItem((String)xva$0)));
        containers.ifPresent(b -> builder.containers(new FluidContainerList((List<FluidContainerList.Category>)b)));
        equivalent.ifPresent(e -> e.forEach(builder::addEqFluid));
        textureFrom.ifPresent(builder::copyTexturesFrom);
        return builder.build();
    }

    protected static SoftFluid merge(SoftFluid originalFluid, SoftFluid newFluid) {
        Builder builder = new Builder(newFluid.stillTexture, newFluid.flowingTexture);
        builder.translationKey(newFluid.getTranslationKey());
        builder.luminosity(newFluid.getLuminosity());
        builder.color(newFluid.getTintColor());
        builder.tintMethod(newFluid.getTintMethod());
        newFluid.getNbtKeyFromItem().forEach(xva$0 -> builder.keepNBTFromItem((String)xva$0));
        originalFluid.getNbtKeyFromItem().forEach(xva$0 -> builder.keepNBTFromItem((String)xva$0));
        FluidContainerList containerList = newFluid.getContainerList();
        containerList.merge(originalFluid.getContainerList());
        builder.containers(containerList);
        newFluid.getEquivalentFluids().forEach(builder::addEqFluid);
        originalFluid.getEquivalentFluids().forEach(builder::addEqFluid);
        if (originalFluid.useTexturesFrom != null) {
            builder.copyTexturesFrom(originalFluid.useTexturesFrom);
        }
        if (newFluid.useTexturesFrom != null) {
            builder.copyTexturesFrom(newFluid.useTexturesFrom);
        }
        return builder.build();
    }

    private static <T> Function<SoftFluid, Optional<T>> getHackyOptional(Function<SoftFluid, T> getter) {
        return f -> {
            Object value = getter.apply((SoftFluid)f);
            Object def = getter.apply(DEFAULT_DUMMY);
            return value == null || value.equals(def) ? Optional.empty() : Optional.of(value);
        };
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addFluidSpecificAttributes(Builder builder, class_3611 fluid) {
        void var1_1;
        SoftFluidImpl.addFluidSpecificAttributes(builder, (class_3611)var1_1);
    }

    @ApiStatus.Internal
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Triplet<class_2960, class_2960, Integer> getRenderingData(class_2960 useTexturesFrom) {
        return SoftFluidImpl.getRenderingData(useTexturesFrom);
    }

    public static class Builder {
        private class_2960 stillTexture;
        private class_2960 flowingTexture;
        private String fromMod = "minecraft";
        private String translationKey = "fluid.moonlight.generic_fluid";
        private int luminosity = 0;
        private int tintColor = -1;
        private TintMethod tintMethod = TintMethod.STILL_AND_FLOWING;
        private FoodProvider food = FoodProvider.EMPTY;
        private FluidContainerList containerList = new FluidContainerList();
        private final List<String> NBTFromItem = new ArrayList<String>();
        private final List<class_3611> equivalentFluids = new ArrayList<class_3611>();
        private boolean isFromData = true;
        private class_2960 useTexturesFrom;

        public Builder(class_2960 stillTexture, class_2960 flowingTexture) {
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public Builder(class_3611 fluid) {
            this(new class_2960("block/water_still"), new class_2960("minecraft:block/water_flowing"));
            this.copyTexturesFrom(Utils.getID(fluid));
            this.addEqFluid(fluid);
            this.isFromData = false;
            SoftFluid.addFluidSpecificAttributes(this, fluid);
        }

        public final Builder textures(class_2960 still, class_2960 flow) {
            this.stillTexture = still;
            this.flowingTexture = flow;
            return this;
        }

        public final Builder translationKey(String translationKey) {
            if (translationKey != null) {
                this.translationKey = translationKey;
            }
            return this;
        }

        public final Builder keepNBTFromItem(String ... NBTkey) {
            this.NBTFromItem.addAll(Arrays.asList(NBTkey));
            return this;
        }

        public final Builder color(int tintColor) {
            this.tintColor = tintColor;
            return this;
        }

        public final Builder noTint() {
            this.tintMethod = TintMethod.NO_TINT;
            return this;
        }

        public final Builder tinted() {
            this.tintMethod = TintMethod.STILL_AND_FLOWING;
            return this;
        }

        public final Builder onlyFlowingTinted() {
            this.tintMethod = TintMethod.FLOWING;
            return this;
        }

        public final Builder tintMethod(TintMethod tint) {
            this.tintMethod = tint;
            return this;
        }

        public final Builder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public final Builder addEqFluid(class_3611 fluid) {
            if (fluid != null && fluid != class_3612.field_15906) {
                this.equivalentFluids.add(fluid);
                class_1792 i = fluid.method_15774();
                if (i != class_1802.field_8162 && i != class_1802.field_8550) {
                    this.bucket(i);
                }
            }
            return this;
        }

        public final Builder copyTexturesFrom(class_2960 fluidRes) {
            this.useTexturesFrom = fluidRes;
            return this;
        }

        public final Builder copyTexturesFrom(String fluidRes) {
            return this.copyTexturesFrom(new class_2960(fluidRes));
        }

        public final Builder containerItem(class_1792 filledItem, class_1792 emptyItem, int itemCapacity) {
            if (filledItem != class_1802.field_8162) {
                this.containerList.add(emptyItem, filledItem, itemCapacity);
            }
            return this;
        }

        public final Builder containerItem(class_1792 filledItem, class_1792 emptyItem, int itemCapacity, class_3414 fillSound, class_3414 emptySound) {
            if (filledItem != class_1802.field_8162) {
                this.containerList.add(emptyItem, filledItem, itemCapacity, fillSound, emptySound);
            }
            return this;
        }

        public final Builder containers(FluidContainerList containerList) {
            this.containerList = containerList;
            return this;
        }

        public final Builder emptyHandContainerItem(class_1792 filledItem, int itemCapacity) {
            if (filledItem != class_1802.field_8162) {
                return this.containerItem(filledItem, class_1802.field_8162, itemCapacity);
            }
            return this;
        }

        public final Builder bottle(class_1792 item) {
            this.containerItem(item, class_1802.field_8469, 1);
            return this;
        }

        public final Builder drink(class_1792 item) {
            return this.bottle(item).food(item, 1);
        }

        public final Builder bucket(class_1792 item) {
            this.containerItem(item, class_1802.field_8550, 4, class_3417.field_15126, class_3417.field_14834);
            return this;
        }

        public final Builder bowl(class_1792 item) {
            this.containerItem(item, class_1802.field_8428, 2);
            return this;
        }

        public final Builder stew(class_1792 item) {
            return this.bowl(item).food(item, 2);
        }

        public final Builder food(class_1792 item) {
            return this.food(item, 1);
        }

        public final Builder food(class_1792 item, int foodDivider) {
            if (item != null) {
                this.food(FoodProvider.create(item, foodDivider));
            }
            return this;
        }

        public final Builder food(FoodProvider foodProvider) {
            this.food = foodProvider;
            return this;
        }

        public SoftFluid build() {
            return new SoftFluid(this);
        }

        public final Builder fromMod(String s) {
            this.fromMod = s;
            return this;
        }
    }

    public static enum TintMethod implements class_3542
    {
        NO_TINT,
        FLOWING,
        STILL_AND_FLOWING;

        public static final Codec<TintMethod> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(TintMethod::values);
        }
    }
}

