/*
 * Decompiled with CFR 0.152.
 */
package net.player005.betteraddserver;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IP2Name {
    public static List<String> alwaysUppercaseWords = Arrays.asList("hd", "yt", "eu", "na", "sa", "as", "pvp", "mc");
    public static List<String> alwaysKeepEndings = Arrays.asList("Land", "Club");

    @Nullable
    public static String toName(@NotNull String ip) {
        String ipNoDots = ip.replace(".", "");
        if (ipNoDots.length() < 3) {
            return null;
        }
        try {
            Integer.parseInt(ipNoDots);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            ip = IP2Name.removeAfterColon(ip);
            CharSequence[] splitIP = ip.split("\\.");
            if (splitIP.length < 1) {
                return null;
            }
            for (int i = 0; i < splitIP.length; ++i) {
                String word = splitIP[i];
                for (String s : alwaysUppercaseWords) {
                    if (!Objects.equals(word, s)) continue;
                    word = word.toUpperCase();
                }
                if (!word.isEmpty()) {
                    word = IP2Name.capitalise(word);
                }
                splitIP[i] = word;
            }
            splitIP[splitIP.length - 1] = splitIP.length == 1 || alwaysKeepEndings.contains(splitIP[splitIP.length - 1]) ? IP2Name.capitalise(splitIP[splitIP.length - 1]) : "";
            return String.join((CharSequence)" ", splitIP);
        }
    }

    @NotNull
    public static String capitalise(@NotNull String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    @Contract(value="_ -> !null", pure=true)
    @NotNull
    public static String removeAfterColon(@NotNull String s) {
        return s.split(":")[0];
    }
}

