/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login;

import com.ibm.asyncutil.locks.AsyncSemaphore;
import com.ibm.asyncutil.locks.FairAsyncSemaphore;
import com.ishland.vmp.mixins.access.IServerChunkManager;
import com.ishland.vmp.mixins.access.IThreadedAnvilChunkStorage;
import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3193;
import net.minecraft.class_3194;
import net.minecraft.class_3204;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3902;
import net.minecraft.class_8563;

public class AsyncChunkLoadUtil {
    private static final class_3230<class_3902> ASYNC_CHUNK_LOAD = class_3230.method_14291((String)"vmp_async_chunk_load", (unit, unit2) -> 0);
    private static final AsyncSemaphore SEMAPHORE = new FairAsyncSemaphore(6L);
    private static final ThreadLocal<Boolean> isRespawnChunkLoadFinished = ThreadLocal.withInitial(() -> false);

    public static CompletableFuture<Either<class_2791, class_3193.class_3724>> scheduleChunkLoad(class_3218 world, class_1923 pos) {
        return AsyncChunkLoadUtil.scheduleChunkLoadWithRadius(world, pos, 3);
    }

    public static CompletableFuture<Either<class_2791, class_3193.class_3724>> scheduleChunkLoadWithRadius(class_3218 world, class_1923 pos, int radius) {
        return AsyncChunkLoadUtil.scheduleChunkLoadWithLevel(world, pos, 33 - radius);
    }

    public static CompletableFuture<Either<class_2791, class_3193.class_3724>> scheduleChunkLoadToStatus(class_3218 world, class_1923 pos, class_2806 status) {
        return AsyncChunkLoadUtil.scheduleChunkLoadWithLevel(world, pos, 33 + class_2806.method_12175((class_2806)status));
    }

    public static CompletableFuture<Either<class_2791, class_3193.class_3724>> scheduleChunkLoadWithLevel(class_3218 world, class_1923 pos, int level) {
        class_3215 chunkManager = world.method_14178();
        class_3204 ticketManager = ((IServerChunkManager)chunkManager).getTicketManager();
        CompletionStage future = SEMAPHORE.acquire().toCompletableFuture().thenComposeAsync(unused -> {
            ticketManager.method_17290(ASYNC_CHUNK_LOAD, pos, level, (Object)class_3902.field_17274);
            ((IServerChunkManager)chunkManager).invokeUpdateChunks();
            class_3193 chunkHolder = ((IThreadedAnvilChunkStorage)chunkManager.field_17254).invokeGetCurrentChunkHolder(pos.method_8324());
            if (chunkHolder == null) {
                throw new IllegalStateException("Chunk not there when requested");
            }
            class_3194 levelType = class_8563.method_51830((int)level);
            return switch (levelType) {
                default -> throw new IncompatibleClassChangeError();
                case class_3194.field_19334 -> chunkHolder.method_13993(class_8563.method_51827((int)level), world.method_14178().field_17254);
                case class_3194.field_44855 -> chunkHolder.method_20725().thenApply(either -> either.mapLeft(Function.identity()));
                case class_3194.field_44856 -> chunkHolder.method_16145().thenApply(either -> either.mapLeft(Function.identity()));
                case class_3194.field_13877 -> chunkHolder.method_14003().thenApply(either -> either.mapLeft(Function.identity()));
            };
        }, (Executor)world.method_8503());
        ((CompletableFuture)future).whenCompleteAsync((unused, throwable) -> {
            SEMAPHORE.release();
            if (throwable != null) {
                throwable.printStackTrace();
            }
            ticketManager.method_20444(ASYNC_CHUNK_LOAD, pos, level, (Object)class_3902.field_17274);
        }, (Executor)world.method_8503());
        return future;
    }

    public static void setIsRespawnChunkLoadFinished(boolean value) {
        isRespawnChunkLoadFinished.set(value);
    }

    public static boolean isRespawnChunkLoadFinished() {
        return isRespawnChunkLoadFinished.get();
    }
}

