/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJq\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Ldev/dediamondpro/resourcify/util/Utils;", "", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "texture", "", "x", "y", "textureX", "textureY", "width", "height", "textureWidth", "textureHeight", "", "textureMinFilter", "textureMagFilter", "", "drawTexture", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/universal/utils/ReleasedDynamicTexture;DDDDDDDDII)V", "Ljava/io/File;", "file", "", "getSha512", "(Ljava/io/File;)Ljava/lang/String;", "Ljava/awt/Color;", "color", "getShadowColor", "(Ljava/awt/Color;)Ljava/awt/Color;", "<init>", "()V", "resourcify"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ndev/dediamondpro/resourcify/util/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final void drawTexture(@NotNull UMatrixStack matrixStack, @NotNull ReleasedDynamicTexture texture, double x, double y, double textureX, double textureY, double width, double height, double textureWidth, double textureHeight, int textureMinFilter, int textureMagFilter) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        matrixStack.push();
        UGraphics.enableBlend();
        UGraphics.enableAlpha();
        matrixStack.scale(1.0f, 1.0f, 50.0f);
        int glId = texture.getDynamicGlId();
        UGraphics.bindTexture((int)0, (int)glId);
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        UGraphics.configureTexture((int)glId, () -> Utils.drawTexture$lambda$0(textureMinFilter, textureMagFilter));
        worldRenderer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
        worldRenderer.pos(matrixStack, x, y + height, 0.0).tex(textureX / textureWidth, (textureY + height) / textureHeight).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        worldRenderer.pos(matrixStack, x + width, y + height, 0.0).tex((textureX + width) / textureWidth, (textureY + height) / textureHeight).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        worldRenderer.pos(matrixStack, x + width, y, 0.0).tex((textureX + width) / textureWidth, textureY / textureHeight).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        worldRenderer.pos(matrixStack, x + 0.0, y + 0.0, 0.0).tex((textureX + 0.0) / textureWidth, (textureY + 0.0) / textureHeight).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        worldRenderer.drawDirect();
        matrixStack.pop();
    }

    public static /* synthetic */ void drawTexture$default(Utils utils, UMatrixStack uMatrixStack, ReleasedDynamicTexture releasedDynamicTexture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n, int n2, int n3, Object object) {
        if ((n3 & 0x400) != 0) {
            n = 9728;
        }
        if ((n3 & 0x800) != 0) {
            n2 = 9728;
        }
        utils.drawTexture(uMatrixStack, releasedDynamicTexture, d, d2, d3, d4, d5, d6, d7, d8, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getSha512(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            Closeable closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
                Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(\"SHA-512\")");
                MessageDigest digest = messageDigest;
                byte[] buffer = new byte[1024];
                int count = 0;
                while (true) {
                    int n;
                    int it2 = n = it.read(buffer);
                    boolean bl2 = false;
                    count = it2;
                    if (n == -1) break;
                    digest.update(buffer, 0, count);
                }
                byte[] byArray = digest.digest();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
                byte[] digested = byArray;
                StringBuilder sb = new StringBuilder();
                for (byte b : digested) {
                    String string = Integer.toString((b & 0xFF) + 256, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                    String string2 = string.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    sb.append(string2);
                }
                String string = sb.toString();
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    @NotNull
    public final Color getShadowColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int rgb = color.getRGB();
        return new Color((rgb & 0xFCFCFC) >> 2 | rgb & 0xFF000000);
    }

    private static final void drawTexture$lambda$0(int $textureMinFilter, int $textureMagFilter) {
        GL11.glTexParameteri((int)3553, (int)10241, (int)$textureMinFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)$textureMagFilter);
    }
}

