/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import gg.essential.universal.UMinecraft;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J!\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\f2\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0004J\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0014\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00170\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R(\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\f0\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019\u00a8\u0006\u001d"}, d2={"Ldev/dediamondpro/resourcify/util/NetworkUtil;", "", "", "clearCache", "()V", "Ljava/net/URL;", "url", "", "attempts", "", "getOrFetch", "(Ljava/net/URL;I)[B", "Ljava/util/concurrent/CompletableFuture;", "getOrFetchAsync", "(Ljava/net/URL;I)Ljava/util/concurrent/CompletableFuture;", "pruneCache", "Ljavax/net/ssl/HttpsURLConnection;", "setupConnection", "(Ljava/net/URL;)Ljavax/net/ssl/HttpsURLConnection;", "startFetch", "MAX_CACHE_SIZE", "I", "Ljava/util/concurrent/ConcurrentHashMap;", "Ldev/dediamondpro/resourcify/util/NetworkUtil$CacheObject;", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "currentlyFetching", "<init>", "CacheObject", "resourcify"})
@SourceDebugExtension(value={"SMAP\nNetworkUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkUtil.kt\ndev/dediamondpro/resourcify/util/NetworkUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,265:1\n1#2:266\n1045#3:267\n*S KotlinDebug\n*F\n+ 1 NetworkUtil.kt\ndev/dediamondpro/resourcify/util/NetworkUtil\n*L\n121#1:267\n*E\n"})
public final class NetworkUtil {
    @NotNull
    public static final NetworkUtil INSTANCE = new NetworkUtil();
    private static final int MAX_CACHE_SIZE = 100000000;
    @NotNull
    private static final ConcurrentHashMap<URL, CacheObject> cache = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<URL, CompletableFuture<byte[]>> currentlyFetching = new ConcurrentHashMap();

    private NetworkUtil() {
    }

    @NotNull
    public final HttpsURLConnection setupConnection(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection con = (HttpsURLConnection)uRLConnection;
        con.setRequestProperty("User-Agent", "Resourcify/1.3.3");
        con.setRequestProperty("Accept-Encoding", "gzip, deflate");
        con.setConnectTimeout(5000);
        con.setReadTimeout(5000);
        return con;
    }

    @Nullable
    public final byte[] getOrFetch(@NotNull URL url, int attempts) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                object = cache.get(url);
                if (object == null) break block4;
                byte[] byArray = ((CacheObject)object).getBytes();
                object = byArray;
                if (byArray != null) break block5;
            }
            CompletableFuture<byte[]> completableFuture = currentlyFetching.get(url);
            Object object2 = completableFuture != null ? completableFuture.get() : null;
            object = object2;
            if (object2 == null) {
                object = this.startFetch(url, attempts).get();
            }
        }
        return object;
    }

    public static /* synthetic */ byte[] getOrFetch$default(NetworkUtil networkUtil, URL uRL, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return networkUtil.getOrFetch(uRL, n);
    }

    @NotNull
    public final CompletableFuture<byte[]> getOrFetchAsync(@NotNull URL url, int attempts) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                object = cache.get(url);
                if (object == null) break block4;
                byte[] byArray = ((CacheObject)object).getBytes();
                object = byArray;
                if (byArray == null) break block4;
                CompletableFuture<byte[]> it = object;
                boolean bl = false;
                CompletableFuture<byte[]> completableFuture = MultiThreadingKt.supplyAsync(() -> NetworkUtil.getOrFetchAsync$lambda$1$lambda$0(it));
                object = completableFuture;
                if (completableFuture != null) break block5;
            }
            if ((object = currentlyFetching.get(url)) == null) {
                object = this.startFetch(url, attempts);
            }
        }
        return object;
    }

    public static /* synthetic */ CompletableFuture getOrFetchAsync$default(NetworkUtil networkUtil, URL uRL, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return networkUtil.getOrFetchAsync(uRL, n);
    }

    private final CompletableFuture<byte[]> startFetch(URL url, int attempts) {
        CompletableFuture<byte[]> completableFuture;
        CompletableFuture<byte[]> $this$startFetch_u24lambda_u245 = completableFuture = MultiThreadingKt.supplyAsync(() -> NetworkUtil.startFetch$lambda$4(attempts, url));
        boolean bl = false;
        ((Map)currentlyFetching).put(url, $this$startFetch_u24lambda_u245);
        CompletionStage completionStage = completableFuture.whenComplete((arg_0, arg_1) -> NetworkUtil.startFetch$lambda$6((Function2)new Function2<byte[], Throwable, Unit>(url){
            final /* synthetic */ URL $url;
            {
                this.$url = $url;
                super(2);
            }

            public final void invoke(@Nullable byte[] byArray, Throwable throwable) {
                NetworkUtil.access$getCurrentlyFetching$p().remove(this.$url);
                NetworkUtil.access$pruneCache(NetworkUtil.INSTANCE);
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"url: URL, attempts: Int)\u2026   pruneCache()\n        }");
        return completionStage;
    }

    /*
     * WARNING - void declaration
     */
    private final void pruneCache() {
        Collection<CacheObject> collection = cache.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"cache.values");
        Iterable iterable = collection;
        int n = 0;
        for (Object t : iterable) {
            void it;
            CacheObject cacheObject = (CacheObject)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getSize();
            n = n2 + n3;
        }
        int cacheSize = n;
        if (cacheSize <= 100000000) {
            return;
        }
        Collection<CacheObject> collection2 = cache.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"cache.values");
        Iterable $this$sortedBy$iv = collection2;
        boolean $i$f$sortedBy = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CacheObject it = (CacheObject)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getLastAccess());
                it = (CacheObject)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getLastAccess()));
            }
        });
        int i2 = 0;
        while (cacheSize > 100000000) {
            Object e = sorted.get(i2);
            Intrinsics.checkNotNullExpressionValue(e, (String)"sorted[i]");
            CacheObject element = (CacheObject)e;
            cache.remove(element.getUrl());
            cacheSize -= element.getSize();
            ++i2;
        }
    }

    public final void clearCache() {
        for (Map.Entry entry : ((Map)currentlyFetching).entrySet()) {
            URL url = (URL)entry.getKey();
            CompletableFuture future = (CompletableFuture)entry.getValue();
            future.cancel(true);
            currentlyFetching.remove(url);
        }
        cache.clear();
    }

    private static final byte[] getOrFetchAsync$lambda$1$lambda$0(byte[] $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return $it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final byte[] startFetch$lambda$4(int $attempts, URL $url) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        for (i = 0; i < $attempts; ++i) {
            try {
                v0 = NetworkUtilKt.getEncodedInputStream($url);
                if (v0 == null) ** GOTO lbl-1000
                var4_5 = (Closeable)v0;
                var5_6 = null;
                try {
                    it = (InputStream)var4_5;
                    $i$a$-use-NetworkUtil$startFetch$1$result$1 = false;
                    it = ByteStreamsKt.readBytes((InputStream)it);
                    v1 = it;
                }
                catch (Throwable it) {
                    var5_6 = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var4_5, (Throwable)var5_6);
                }
                v0 = v1;
                if (v1 != null) {
                    it = v0;
                    $i$a$-let-NetworkUtil$startFetch$1$result$2 = false;
                    ((Map)NetworkUtil.cache).put($url, new CacheObject($url, (byte[])it, 0L, 4, null));
                    v2 = it;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = result = null;
                }
                if (result != null) {
                    return result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Thread.sleep(250L);
        }
        return null;
    }

    private static final void startFetch$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getCurrentlyFetching$p() {
        return currentlyFetching;
    }

    public static final /* synthetic */ void access$pruneCache(NetworkUtil $this) {
        $this.pruneCache();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c2\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\f\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001bR\"\u0010\r\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u001c\u001a\u0004\b\u001d\u0010\n\"\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010\u0017R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010#\u001a\u0004\b$\u0010\u0004\u00a8\u0006'"}, d2={"Ldev/dediamondpro/resourcify/util/NetworkUtil$CacheObject;", "", "Ljava/net/URL;", "component1", "()Ljava/net/URL;", "", "component2", "()[B", "", "component3", "()J", "url", "bytes", "lastAccess", "copy", "(Ljava/net/URL;[BJ)Ldev/dediamondpro/resourcify/util/NetworkUtil$CacheObject;", "other", "", "equals", "(Ljava/lang/Object;)Z", "getBytes", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "[B", "J", "getLastAccess", "setLastAccess", "(J)V", "size", "I", "getSize", "Ljava/net/URL;", "getUrl", "<init>", "(Ljava/net/URL;[BJ)V", "resourcify"})
    private static final class CacheObject {
        @NotNull
        private final URL url;
        @NotNull
        private final byte[] bytes;
        private long lastAccess;
        private final int size;

        public CacheObject(@NotNull URL url, @NotNull byte[] bytes, long lastAccess) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            this.url = url;
            this.bytes = bytes;
            this.lastAccess = lastAccess;
            this.size = this.bytes.length;
        }

        public /* synthetic */ CacheObject(URL uRL, byte[] byArray, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = UMinecraft.getTime();
            }
            this(uRL, byArray, l);
        }

        @NotNull
        public final URL getUrl() {
            return this.url;
        }

        public final long getLastAccess() {
            return this.lastAccess;
        }

        public final void setLastAccess(long l) {
            this.lastAccess = l;
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final byte[] getBytes() {
            this.lastAccess = UMinecraft.getTime();
            return this.bytes;
        }

        @NotNull
        public final URL component1() {
            return this.url;
        }

        private final byte[] component2() {
            return this.bytes;
        }

        public final long component3() {
            return this.lastAccess;
        }

        @NotNull
        public final CacheObject copy(@NotNull URL url, @NotNull byte[] bytes, long lastAccess) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return new CacheObject(url, bytes, lastAccess);
        }

        public static /* synthetic */ CacheObject copy$default(CacheObject cacheObject, URL uRL, byte[] byArray, long l, int n, Object object) {
            if ((n & 1) != 0) {
                uRL = cacheObject.url;
            }
            if ((n & 2) != 0) {
                byArray = cacheObject.bytes;
            }
            if ((n & 4) != 0) {
                l = cacheObject.lastAccess;
            }
            return cacheObject.copy(uRL, byArray, l);
        }

        @NotNull
        public String toString() {
            return "CacheObject(url=" + this.url + ", bytes=" + Arrays.toString(this.bytes) + ", lastAccess=" + this.lastAccess + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + Arrays.hashCode(this.bytes);
            result = result * 31 + Long.hashCode(this.lastAccess);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheObject)) {
                return false;
            }
            CacheObject cacheObject = (CacheObject)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)cacheObject.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bytes, (Object)cacheObject.bytes)) {
                return false;
            }
            return this.lastAccess == cacheObject.lastAccess;
        }
    }
}

