/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements.impl;

import dev.dediamondpro.resourcify.libs.minemark.LayoutData;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.elements.Inline;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class TextElement<S extends Style, R>
extends Element<S, R>
implements Inline {
    protected final HashMap<LayoutData.MarkDownElementPosition, String> lines = new HashMap();
    protected final String text;
    protected float baseLineHeight;
    protected float ascender;
    protected float descender;

    public TextElement(@NotNull String text, @NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes) {
        super(style, layoutStyle, parent, qName, attributes);
        this.text = text;
    }

    @Override
    public void generateLayout(LayoutData layoutData, R renderData) {
        this.lines.clear();
        ArrayList<String> allLines = new ArrayList<String>();
        String actualText = this.text;
        if (!this.getLayoutStyle().isPreFormatted()) {
            actualText = actualText.replaceAll(" +", " ");
        }
        String[] predefinedLines = actualText.split("\n", -1);
        for (int i2 = 0; i2 < predefinedLines.length; ++i2) {
            String line = predefinedLines[i2].replace("\n", "");
            if (this.layoutStyle.isPreFormatted()) {
                allLines.add(line);
                continue;
            }
            allLines.addAll(this.wrapText(line, i2 == 0 ? layoutData.getX() : 0.0f, layoutData.getMaxWidth(), renderData));
        }
        float codeBlockPadding = this.layoutStyle.isPartOfCodeBlock() ? this.style.getCodeBlockStyle().getInlinePaddingTopBottom() : 0.0f;
        float padding = Math.max(this.style.getTextStyle().getPadding(), codeBlockPadding);
        float fontSize = this.layoutStyle.getFontSize();
        this.baseLineHeight = this.getBaselineHeight(fontSize, renderData);
        this.ascender = this.getAscender(fontSize, renderData);
        this.descender = this.getDescender(fontSize, renderData);
        for (int i3 = 0; i3 < allLines.size(); ++i3) {
            String line = (String)allLines.get(i3);
            layoutData.updatePadding(padding);
            this.lines.put(layoutData.addElement(this.layoutStyle.getAlignment(), this.getAdjustedTextWidth(line, fontSize, renderData), this.baseLineHeight), line);
            if (i3 == allLines.size() - 1) continue;
            layoutData.nextLine();
        }
    }

    @Override
    public void drawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        boolean hovered = false;
        for (LayoutData.MarkDownElementPosition position : this.lines.keySet()) {
            if (!position.isInside(mouseX, mouseY)) continue;
            hovered = true;
            break;
        }
        float paddingLeftRight = this.layoutStyle.isPartOfCodeBlock() ? this.style.getCodeBlockStyle().getInlinePaddingLeftRight() : 0.0f;
        float paddingTopBottom = this.layoutStyle.isPartOfCodeBlock() ? this.style.getCodeBlockStyle().getInlinePaddingTopBottom() : 0.0f;
        for (Map.Entry<LayoutData.MarkDownElementPosition, String> line : this.lines.entrySet()) {
            LayoutData.MarkDownElementPosition position = line.getKey();
            String text = line.getValue();
            if (this.layoutStyle.isPartOfCodeBlock() && !this.layoutStyle.isPreFormatted()) {
                this.drawInlineCodeBlock(position.getX() + xOffset, position.getY() + yOffset - paddingTopBottom, position.getWidth(), position.getHeight() + paddingTopBottom * 2.0f, this.style.getCodeBlockStyle().getColor(), renderData);
            }
            this.drawText(text, position.getX() + xOffset + paddingLeftRight, position.getY() + yOffset - this.ascender, this.layoutStyle.getFontSize(), this.layoutStyle.getTextColor(), hovered, position, renderData);
        }
    }

    protected List<String> wrapText(String text, float startX, float maxWidth, R renderData) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        float fontSize = this.layoutStyle.getFontSize();
        String[] words = text.split("(?= )");
        float actualMaxWidth = maxWidth - startX;
        for (String word : words) {
            word = word.replace('\u00a0', ' ');
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getAdjustedTextWidth(stringBuilder.append((Object)currentLine).append(word).toString(), fontSize, renderData) <= actualMaxWidth) {
                currentLine.append(word);
                continue;
            }
            String finishedText = currentLine.toString();
            if (!finishedText.isEmpty() || actualMaxWidth != maxWidth) {
                lines.add(finishedText);
            }
            String cleanedWord = word.replaceAll("^ ", "");
            currentLine = new StringBuilder();
            actualMaxWidth = maxWidth;
            if (this.getAdjustedTextWidth(cleanedWord, fontSize, renderData) > actualMaxWidth) {
                String wordCarry = cleanedWord;
                while (!wordCarry.isEmpty()) {
                    if (currentLine.length() != 0) {
                        lines.add(currentLine.toString());
                    }
                    currentLine = new StringBuilder(wordCarry);
                    while (this.getAdjustedTextWidth(currentLine.toString(), fontSize, renderData) > actualMaxWidth && currentLine.length() > 1) {
                        currentLine.deleteCharAt(currentLine.length() - 1);
                    }
                    wordCarry = wordCarry.substring(currentLine.length());
                }
                continue;
            }
            currentLine.append(cleanedWord);
        }
        lines.add(currentLine.toString());
        return lines;
    }

    protected float getAdjustedTextWidth(@NotNull String text, float fontSize, R renderData) {
        return this.getTextWidth(text, fontSize, renderData) + (this.layoutStyle.isPartOfCodeBlock() ? this.style.getCodeBlockStyle().getInlinePaddingLeftRight() * 2.0f : 0.0f);
    }

    protected abstract void drawText(@NotNull String var1, float var2, float var3, float var4, Color var5, boolean var6, LayoutData.MarkDownElementPosition var7, @NotNull R var8);

    protected abstract void drawInlineCodeBlock(float var1, float var2, float var3, float var4, Color var5, @NotNull R var6);

    protected abstract float getTextWidth(@NotNull String var1, float var2, R var3);

    protected abstract float getBaselineHeight(float var1, R var2);

    protected float getAscender(float fontSize, R renderData) {
        return 0.0f;
    }

    protected float getDescender(float fontSize, R renderData) {
        return 0.0f;
    }

    public String toString() {
        return "TextElement {" + this.text + "}";
    }
}

