/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.elementa.font.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dediamondpro.resourcify.libs.elementa.font.data.Atlas;
import dev.dediamondpro.resourcify.libs.elementa.font.data.Glyph;
import dev.dediamondpro.resourcify.libs.elementa.font.data.Metrics;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B+\u0012\u0006\u0010\r\u001a\u00020\u0002\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ:\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00052\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\r\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001b\u001a\u0004\b\u001c\u0010\u0004R#\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u001d\u001a\u0004\b\u001e\u0010\fR\u0017\u0010\u000e\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001f\u001a\u0004\b \u0010\u0007\u00a8\u0006$"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/font/data/FontInfo;", "", "Ldev/dediamondpro/resourcify/libs/elementa/font/data/Atlas;", "component1", "()Lgg/essential/elementa/font/data/Atlas;", "Ldev/dediamondpro/resourcify/libs/elementa/font/data/Metrics;", "component2", "()Lgg/essential/elementa/font/data/Metrics;", "", "", "Ldev/dediamondpro/resourcify/libs/elementa/font/data/Glyph;", "component3", "()Ljava/util/Map;", "atlas", "metrics", "glyphs", "copy", "(Lgg/essential/elementa/font/data/Atlas;Lgg/essential/elementa/font/data/Metrics;Ljava/util/Map;)Lgg/essential/elementa/font/data/FontInfo;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ldev/dediamondpro/resourcify/libs/elementa/font/data/Atlas;", "getAtlas", "Ljava/util/Map;", "getGlyphs", "Ldev/dediamondpro/resourcify/libs/elementa/font/data/Metrics;", "getMetrics", "<init>", "(Lgg/essential/elementa/font/data/Atlas;Lgg/essential/elementa/font/data/Metrics;Ljava/util/Map;)V", "Companion", "Elementa"})
public final class FontInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Atlas atlas;
    @NotNull
    private final Metrics metrics;
    @NotNull
    private final Map<Integer, Glyph> glyphs;
    @NotNull
    private static final Gson gson = new Gson();

    public FontInfo(@NotNull Atlas atlas, @NotNull Metrics metrics, @NotNull Map<Integer, Glyph> glyphs) {
        Intrinsics.checkNotNullParameter((Object)atlas, (String)"atlas");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter(glyphs, (String)"glyphs");
        this.atlas = atlas;
        this.metrics = metrics;
        this.glyphs = glyphs;
    }

    @NotNull
    public final Atlas getAtlas() {
        return this.atlas;
    }

    @NotNull
    public final Metrics getMetrics() {
        return this.metrics;
    }

    @NotNull
    public final Map<Integer, Glyph> getGlyphs() {
        return this.glyphs;
    }

    @NotNull
    public final Atlas component1() {
        return this.atlas;
    }

    @NotNull
    public final Metrics component2() {
        return this.metrics;
    }

    @NotNull
    public final Map<Integer, Glyph> component3() {
        return this.glyphs;
    }

    @NotNull
    public final FontInfo copy(@NotNull Atlas atlas, @NotNull Metrics metrics, @NotNull Map<Integer, Glyph> glyphs) {
        Intrinsics.checkNotNullParameter((Object)atlas, (String)"atlas");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter(glyphs, (String)"glyphs");
        return new FontInfo(atlas, metrics, glyphs);
    }

    public static /* synthetic */ FontInfo copy$default(FontInfo fontInfo, Atlas atlas, Metrics metrics, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            atlas = fontInfo.atlas;
        }
        if ((n & 2) != 0) {
            metrics = fontInfo.metrics;
        }
        if ((n & 4) != 0) {
            map2 = fontInfo.glyphs;
        }
        return fontInfo.copy(atlas, metrics, map2);
    }

    @NotNull
    public String toString() {
        return "FontInfo(atlas=" + this.atlas + ", metrics=" + this.metrics + ", glyphs=" + this.glyphs + ')';
    }

    public int hashCode() {
        int result = this.atlas.hashCode();
        result = result * 31 + this.metrics.hashCode();
        result = result * 31 + ((Object)this.glyphs).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FontInfo)) {
            return false;
        }
        FontInfo fontInfo = (FontInfo)other;
        if (!Intrinsics.areEqual((Object)this.atlas, (Object)fontInfo.atlas)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.metrics, (Object)fontInfo.metrics)) {
            return false;
        }
        return Intrinsics.areEqual(this.glyphs, fontInfo.glyphs);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/font/data/FontInfo$Companion;", "", "Lcom/google/gson/JsonObject;", "json", "Ldev/dediamondpro/resourcify/libs/elementa/font/data/FontInfo;", "fromJson", "(Lcom/google/gson/JsonObject;)Lgg/essential/elementa/font/data/FontInfo;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "<init>", "()V", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FontInfo fromJson(@NotNull JsonObject json) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Atlas atlas = (Atlas)gson.fromJson((JsonElement)json.getAsJsonObject("atlas"), Atlas.class);
            Metrics metrics = (Metrics)gson.fromJson((JsonElement)json.getAsJsonObject("metrics"), Metrics.class);
            JsonArray jsonArray = json.getAsJsonArray("glyphs");
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"json.getAsJsonArray(\"glyphs\")");
            Iterable $this$associate$iv = (Iterable)jsonArray;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                JsonElement glyphElement = (JsonElement)element$iv$iv;
                boolean bl = false;
                Glyph glyph = (Glyph)gson.fromJson(glyphElement, Glyph.class);
                Pair pair = TuplesKt.to((Object)glyph.getUnicode(), (Object)glyph);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map glyphs = destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)atlas, (String)"atlas");
            Intrinsics.checkNotNullExpressionValue((Object)metrics, (String)"metrics");
            return new FontInfo(atlas, metrics, glyphs);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

