/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.utils;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.mixin.fields.ClientLevelFields;
import com.mt1006.nbt_ac.mixin.fields.EntitySelectorFields;
import com.mt1006.nbt_ac.utils.Fields;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2267;
import net.minecraft.class_2280;
import net.minecraft.class_2300;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5575;
import net.minecraft.class_5582;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private static final class_2168 DUMMY_COMMAND_SOURCE_STACK = new class_2168(null, class_243.field_1353, class_241.field_1340, null, 0, null, null, null, null);

    public static String getNodeString(CommandContext<?> ctx, int pos) {
        return ((ParsedCommandNode)ctx.getNodes().get(pos)).getNode().getName();
    }

    public static String getCommandName(CommandContext<?> ctx) {
        String name = Utils.getNodeString(ctx, 0);
        if (((Boolean)ModConfig.supportCommandNamespace.val).booleanValue() && name.startsWith("minecraft:")) {
            return name.substring(10);
        }
        return name;
    }

    public static String getArgumentString(CommandContext<?> ctx, String argumentName) {
        Map arguments;
        try {
            arguments = (Map)Fields.commandContextArguments.get(ctx);
        }
        catch (Exception exception) {
            return null;
        }
        ParsedArgument argument = (ParsedArgument)arguments.get(argumentName);
        if (argument == null) {
            return null;
        }
        return argument.getRange().get(ctx.getInput());
    }

    public static String blockFromCoords(class_2267 coords) {
        if (!(coords instanceof class_2280)) {
            return null;
        }
        if (coords.method_9705() || coords.method_9706() || coords.method_9707()) {
            return null;
        }
        class_2338 blockPos = coords.method_9704(DUMMY_COMMAND_SOURCE_STACK);
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        class_2248 block = level.method_8320(blockPos).method_26204();
        return "block/" + RegistryUtils.BLOCK.getKey(block);
    }

    public static String entityFromEntitySelector(class_2300 entitySelector) {
        return Utils.entityFromSelectorData(((EntitySelectorFields)entitySelector).getType(), ((EntitySelectorFields)entitySelector).getEntityUUID(), ((EntitySelectorFields)entitySelector).getPlayerName());
    }

    public static String entityFromSelectorData(class_5575<class_1297, ?> typeTest, @Nullable UUID uuid, @Nullable String playerName) {
        if (typeTest instanceof class_1299) {
            return "entity/" + RegistryUtils.ENTITY_TYPE.getKey((class_1299)typeTest);
        }
        class_638 clientLevel = class_310.method_1551().field_1687;
        if (clientLevel == null) {
            return null;
        }
        if (uuid != null) {
            try {
                class_5582<class_1297> entityStorage = ((ClientLevelFields)clientLevel).getEntityStorage();
                class_1297 entity = (class_1297)entityStorage.method_31866().method_31808(uuid);
                if (entity == null) {
                    return null;
                }
                return "entity/" + RegistryUtils.ENTITY_TYPE.getKey(entity.method_5864());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (playerName == null) {
            return null;
        }
        for (class_1657 player : clientLevel.method_18456()) {
            if (!player.method_7334().getName().equals(playerName)) continue;
            return "entity/" + class_1299.method_5890((class_1299)class_1299.field_6097);
        }
        return null;
    }

    public static boolean isModPresent(String id) {
        return FabricLoader.getInstance().getModContainer(id).isPresent();
    }
}

