/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.suggestions;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.utils.Fields;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class CustomSuggestion {
    public abstract String getSuggestionText();

    public abstract String getSuggestionSubtext();

    public abstract Message getSuggestionTooltip();

    public void suggest(SuggestionsBuilder suggestionsBuilder, Map<Suggestion, String> subtextMap) {
        String text = this.getSuggestionText();
        String subtext = this.getSuggestionSubtext();
        Message tooltip = this.getSuggestionTooltip();
        if (text.isEmpty() && suggestionsBuilder.getRemaining().isEmpty()) {
            if (!this.emptySuggestion(suggestionsBuilder, tooltip)) {
                return;
            }
        } else {
            suggestionsBuilder.suggest(text, tooltip);
        }
        if (!((Boolean)ModConfig.showTagTypes.val).booleanValue()) {
            return;
        }
        Suggestion lastAdded = CustomSuggestion.getLastAddedSuggestion(suggestionsBuilder);
        if (lastAdded != null) {
            subtextMap.put(lastAdded, subtext);
        }
    }

    private boolean emptySuggestion(SuggestionsBuilder suggestionsBuilder, Message tooltip) {
        if (!((Boolean)ModConfig.showTagTypes.val).booleanValue()) {
            return true;
        }
        if (Fields.suggestionsBuilderList == null) {
            return false;
        }
        try {
            List suggestions = (List)Fields.suggestionsBuilderList.get(suggestionsBuilder);
            int start = (Integer)Fields.suggestionsBuilderInt.get(suggestionsBuilder);
            int len = 0;
            for (Field stringField : Fields.suggestionsBuilderStrings) {
                String val = (String)stringField.get(suggestionsBuilder);
                if (val == null || val.length() <= len) continue;
                len = val.length();
            }
            suggestions.add(new Suggestion(StringRange.between((int)start, (int)len), "", tooltip));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Nullable
    private static Suggestion getLastAddedSuggestion(SuggestionsBuilder suggestionsBuilder) {
        if (Fields.suggestionsBuilderList == null) {
            return null;
        }
        try {
            List suggestionList = (List)Fields.suggestionsBuilderList.get(suggestionsBuilder);
            return (Suggestion)suggestionList.get(suggestionList.size() - 1);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

