/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.typeloader;

import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.loader.Loader;
import com.mt1006.nbt_ac.autocomplete.loader.typeloader.Disassembly;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import com.mt1006.nbt_ac.utils.Utils;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2669;
import net.minecraft.class_2960;

public class TypeLoader {
    public static volatile boolean getClasses = false;
    public static Class<?> lastClass = null;

    public static void loadEntityTypes() {
        getClasses = true;
        for (class_1299<?> entityType : RegistryUtils.ENTITY_TYPE) {
            class_2960 resourceName;
            block8: {
                lastClass = null;
                resourceName = class_1299.method_5890(entityType);
                if (resourceName.toString().equals("minecraft:player")) {
                    lastClass = class_1657.class;
                } else {
                    try {
                        entityType.method_5883(null);
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof Error)) break block8;
                        NBTac.LOGGER.error("Entity \"" + resourceName + "\" constructor thrown error: " + throwable);
                    }
                }
            }
            if (lastClass != null) {
                try {
                    NbtSuggestions suggestions = new NbtSuggestions();
                    Disassembly.disassemblyEntity(lastClass, suggestions);
                    NbtSuggestionManager.add("entity/" + resourceName, suggestions);
                }
                catch (Exception exception) {
                    NBTac.LOGGER.error("Failed to load entity \"" + resourceName + "\": " + exception);
                    Loader.printStackTrace(exception);
                }
                continue;
            }
            NBTac.LOGGER.error("Unable to get entity class for \"" + resourceName + "\"");
        }
        getClasses = false;
    }

    public static void loadBlockEntityTypes() {
        getClasses = true;
        boolean pistonCrashFix = Utils.isModPresent("moreculling") && Utils.isModPresent("modernfix") && Utils.isModPresent("lithium");
        for (class_2591<?> blockEntityType : RegistryUtils.BLOCK_ENTITY_TYPE) {
            class_2960 resourceName;
            block8: {
                lastClass = null;
                resourceName = class_2591.method_11033(blockEntityType);
                if (pistonCrashFix && blockEntityType == class_2591.field_11897) {
                    lastClass = class_2669.class;
                }
                if (lastClass == null) {
                    try {
                        blockEntityType.method_11032(class_2338.field_10980, null);
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof Error)) break block8;
                        NBTac.LOGGER.error("Block entity \"" + resourceName + "\" constructor thrown error: " + throwable);
                    }
                }
            }
            if (lastClass != null) {
                try {
                    NbtSuggestions suggestions = new NbtSuggestions();
                    Disassembly.disassemblyBlockEntity(lastClass, suggestions);
                    NbtSuggestionManager.add("block/" + resourceName, suggestions);
                }
                catch (Exception exception) {
                    NBTac.LOGGER.error("Failed to load block entity \"" + resourceName + "\": " + exception);
                    Loader.printStackTrace(exception);
                }
                continue;
            }
            NBTac.LOGGER.error("Unable to get block entity class for \"" + resourceName + "\"");
        }
        getClasses = false;
    }
}

