/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.resourceloader;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.loader.Loader;
import com.mt1006.nbt_ac.config.ModConfig;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_7654;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ResourceLoader
implements SimpleResourceReloadListener<Map<class_2960, JsonElement>> {
    private static final String RESOURCE_DIRECTORY = "nbt_ac_suggestions";
    public static final List<Pair<String, JsonObject>> common = new ArrayList<Pair<String, JsonObject>>();
    public static final List<Pair<String, JsonObject>> tags = new ArrayList<Pair<String, JsonObject>>();
    public static final List<Pair<JsonArray, JsonArray>> predictions = new ArrayList<Pair<JsonArray, JsonArray>>();
    public static boolean firstCall = true;
    public static CountDownLatch countDownLatch = new CountDownLatch(1);

    public class_2960 getFabricId() {
        return new class_2960("nbt_ac", "nbt_ac");
    }

    public CompletableFuture<Map<class_2960, JsonElement>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> this.prepare(manager, profiler));
    }

    @NotNull
    private Map<class_2960, JsonElement> prepare(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        Gson gson = new Gson();
        HashMap map = Maps.newHashMap();
        class_7654 fileToIdConverter = class_7654.method_45114((String)RESOURCE_DIRECTORY);
        for (Map.Entry entry : fileToIdConverter.method_45113(resourceManager).entrySet()) {
            class_2960 resourceLocation = fileToIdConverter.method_45115((class_2960)entry.getKey());
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)gson, (Reader)reader, JsonElement.class);
                    map.put(resourceLocation, jsonElement);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception exception) {}
        }
        return map;
    }

    public CompletableFuture<Void> apply(@NotNull Map<class_2960, JsonElement> resources, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller, Executor executor) {
        if (!firstCall) {
            return CompletableFuture.runAsync(() -> {});
        }
        firstCall = false;
        for (Map.Entry<class_2960, JsonElement> resourceEntry : resources.entrySet()) {
            try {
                JsonObject json = resourceEntry.getValue().getAsJsonObject();
                MutablePair predictionPair = new MutablePair(null, null);
                for (Map.Entry entry : json.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    if (key.equals("conditions")) {
                        predictionPair.left = value.getAsJsonArray();
                        continue;
                    }
                    if (key.equals("operations")) {
                        predictionPair.right = value.getAsJsonArray();
                        continue;
                    }
                    if (key.startsWith("common/")) {
                        common.add((Pair<String, JsonObject>)new ImmutablePair((Object)key, (Object)value.getAsJsonObject()));
                        continue;
                    }
                    if (key.startsWith("tag/")) {
                        tags.add((Pair<String, JsonObject>)new ImmutablePair((Object)key, (Object)value.getAsJsonObject()));
                        continue;
                    }
                    if (!key.startsWith("parent/")) continue;
                    tags.add((Pair<String, JsonObject>)new ImmutablePair(null, (Object)value.getAsJsonObject()));
                }
                if (predictionPair.left == null || predictionPair.right == null) continue;
                predictions.add((Pair<JsonArray, JsonArray>)predictionPair);
            }
            catch (Exception exception) {
                NBTac.LOGGER.warn("Failed to load resource: " + resourceEntry.getKey().toString());
            }
        }
        countDownLatch.countDown();
        if (!((Boolean)ModConfig.useNewThread.val).booleanValue()) {
            Loader.load();
        }
        return CompletableFuture.runAsync(() -> {});
    }
}

