/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete;

import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.loader.Loader;
import com.mt1006.nbt_ac.autocomplete.suggestions.CustomSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.SimpleSuggestion;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1747;
import net.minecraft.class_1826;
import org.jetbrains.annotations.Nullable;

public class NbtSuggestionManager {
    public static final Map<String, NbtSuggestions> suggestionMap = new HashMap<String, NbtSuggestions>();
    public static final Map<Suggestion, String> subtextMap = new IdentityHashMap<Suggestion, String>();

    public static void add(String key, NbtSuggestions suggestions) {
        suggestionMap.put(key, suggestions);
    }

    public static NbtSuggestions get(String key) {
        if (key == null) {
            return null;
        }
        return suggestionMap.get(key);
    }

    public static CompletableFuture<Suggestions> loadFromName(String name, String tag, SuggestionsBuilder suggestionsBuilder, boolean suggestPath) {
        return NbtSuggestionManager.load(NbtSuggestionManager.get(name), tag, suggestionsBuilder, suggestPath, name, null);
    }

    public static CompletableFuture<Suggestions> loadFromSuggestion(NbtSuggestion suggestion, String tag, SuggestionsBuilder suggestionsBuilder) {
        return NbtSuggestionManager.load(suggestion.subcompound, tag, suggestionsBuilder, false, null, suggestion);
    }

    public static CompletableFuture<Suggestions> load(@Nullable NbtSuggestions suggestions, String tag, SuggestionsBuilder suggestionsBuilder, boolean suggestPath, @Nullable String rootTag, @Nullable NbtSuggestion rootSuggestion) {
        if (!Loader.finished) {
            NbtSuggestionManager.simpleSuggestion("", "\u00a78[suggestions not loaded]", suggestionsBuilder);
            return suggestionsBuilder.buildFuture();
        }
        String rootName = rootTag != null ? rootTag : (rootSuggestion != null ? rootSuggestion.tag : null);
        ArrayList<CustomSuggestion> suggestionList = new ArrayList<CustomSuggestion>();
        NbtSuggestionManager.addToList(suggestionList, suggestions, rootTag);
        CustomTagParser customTagParser = new CustomTagParser(tag);
        CustomTagParser.Suggestion suggestionToShow = customTagParser.read(suggestionList, rootSuggestion, rootName, suggestPath);
        SuggestionsBuilder newSuggestionsBuilder = suggestionsBuilder.createOffset(suggestionsBuilder.getStart() + customTagParser.reader.getCursor());
        if (suggestionToShow == CustomTagParser.Suggestion.TAG) {
            suggestionList.forEach(s -> s.suggest(newSuggestionsBuilder, subtextMap));
        } else {
            suggestionToShow.suggest(newSuggestionsBuilder);
        }
        return newSuggestionsBuilder.buildFuture();
    }

    public static void addToList(List<CustomSuggestion> suggestionList, @Nullable NbtSuggestions suggestions, @Nullable String rootTag) {
        if (suggestions != null) {
            suggestionList.addAll(suggestions.getAll());
        }
        for (NbtSuggestions commonSuggestions : NbtSuggestionManager.getCommonSuggestions(rootTag)) {
            if (commonSuggestions == null) continue;
            suggestionList.addAll(commonSuggestions.getAll());
        }
    }

    public static void simpleSuggestion(String text, String subtext, SuggestionsBuilder suggestionsBuilder) {
        new SimpleSuggestion(text, subtext).suggest(suggestionsBuilder, subtextMap);
    }

    public static String getSubtext(Suggestion suggestion) {
        return subtextMap.get(suggestion);
    }

    private static List<@Nullable NbtSuggestions> getCommonSuggestions(@Nullable String tag) {
        if (tag == null) {
            return Collections.emptyList();
        }
        ArrayList<NbtSuggestions> list = new ArrayList<NbtSuggestions>();
        if (tag.startsWith("item/")) {
            if (RegistryUtils.ITEM.get(tag.substring(5)) instanceof class_1747) {
                list.add(NbtSuggestionManager.get("common/block_item"));
            }
            if (RegistryUtils.ITEM.get(tag.substring(5)) instanceof class_1826) {
                list.add(NbtSuggestionManager.get("common/spawn_egg_item"));
            }
            list.add(NbtSuggestionManager.get("common/item"));
        } else if (tag.startsWith("block/")) {
            list.add(NbtSuggestionManager.get("common/block"));
        } else if (tag.startsWith("entity/")) {
            list.add(NbtSuggestionManager.get("common/entity"));
        }
        return list;
    }
}

