/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigDefaults;
import dzwdz.chat_heads.config.SenderDetection;
import dzwdz.chat_heads.mixinterface.GuiMessageOwnerAccessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_2556;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_7463;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatHeads {
    public static final String MOD_ID = "chat_heads";
    public static final String NON_NAME_REGEX = "(\u00a7.)|[^\\w]";
    public static final class_2960 DISABLE_RESOURCE = new class_2960("chat_heads", "disable");
    public static ChatHeadsConfig CONFIG = new ChatHeadsConfigDefaults();
    @Nullable
    public static class_640 lastSender;
    public static boolean refreshing;
    @Nullable
    public static class_640 lineOwner;
    @Nullable
    public static class_640 refreshingLineOwner;
    @Nullable
    public static class_303.class_7590 lastGuiMessage;
    public static int lastY;
    public static float lastOpacity;
    public static int lastChatOffset;
    public static volatile boolean serverSentUuid;
    public static volatile boolean serverDisabledChatHeads;
    public static final Set<class_2960> blendedHeadTextures;

    public static class_640 getLineOwner() {
        return refreshing ? refreshingLineOwner : lineOwner;
    }

    public static void resetLineOwner() {
        if (refreshing) {
            refreshingLineOwner = null;
        } else {
            lineOwner = null;
        }
    }

    public static void handleAddedMessage(class_2561 message, @Nullable class_2556.class_7602 bound, @Nullable class_640 playerInfo) {
        if (serverDisabledChatHeads) {
            lastSender = null;
            return;
        }
        if (CONFIG.senderDetection() != SenderDetection.HEURISTIC_ONLY) {
            if (playerInfo != null) {
                lastSender = playerInfo;
                serverSentUuid = true;
                return;
            }
            if (CONFIG.senderDetection() == SenderDetection.UUID_ONLY || serverSentUuid && CONFIG.smartHeuristics()) {
                lastSender = null;
                return;
            }
        }
        lastSender = ChatHeads.detectPlayer(message, bound);
    }

    public static int getChatOffset(@NotNull class_303.class_7590 guiMessage) {
        class_640 owner = ((GuiMessageOwnerAccessor)guiMessage).chatheads$getOwner();
        return ChatHeads.getChatOffset(owner);
    }

    public static int getChatOffset(@Nullable class_640 owner) {
        if (owner != null || CONFIG.offsetNonPlayerText() && !serverDisabledChatHeads) {
            return 10;
        }
        return 0;
    }

    @Nullable
    public static class_640 detectPlayer(class_2561 message, @Nullable class_2556.class_7602 bound) {
        class_640 player;
        class_634 connection = class_310.method_1551().method_1562();
        if (connection == null) {
            return null;
        }
        HashMap<String, class_640> profileNameCache = new HashMap<String, class_640>();
        HashMap<String, class_640> nicknameCache = new HashMap<String, class_640>();
        class_2561 sender = ChatHeads.getSenderDecoration(bound);
        if (sender != null) {
            class_640 player2;
            Optional<String> tellReceiver = ChatHeads.getTellReceiver(sender);
            if (tellReceiver.isPresent() && (player2 = ChatHeads.getPlayerInfo(tellReceiver.get(), connection, profileNameCache, nicknameCache)) != null) {
                return player2;
            }
            String cleanSender = sender.getString().replaceAll(NON_NAME_REGEX, "");
            return ChatHeads.getPlayerInfo(cleanSender, connection, profileNameCache, nicknameCache);
        }
        Optional<String> tellReceiver = ChatHeads.getTellReceiver(message);
        if (tellReceiver.isPresent() && (player = ChatHeads.getPlayerInfo(tellReceiver.get(), connection, profileNameCache, nicknameCache)) != null) {
            return player;
        }
        for (String word : message.getString().split(NON_NAME_REGEX)) {
            class_640 player3;
            if (word.isEmpty() || (player3 = ChatHeads.getPlayerInfo(word, connection, profileNameCache, nicknameCache)) == null) continue;
            return player3;
        }
        return null;
    }

    private static Optional<String> getTellReceiver(class_2561 component) {
        return component.method_27658((style, string) -> {
            String cmd;
            class_2558 clickEvent = style.method_10970();
            if (clickEvent != null && (cmd = clickEvent.method_10844()).startsWith("/tell ")) {
                String name = cmd.substring("/tell ".length());
                return Optional.of(name.replaceAll(NON_NAME_REGEX, ""));
            }
            return Optional.empty();
        }, class_2583.field_24360);
    }

    @Nullable
    private static class_2561 getSenderDecoration(@Nullable class_2556.class_7602 bound) {
        if (bound == null) {
            return null;
        }
        for (class_7463.class_7464 param : bound.comp_919().comp_792().comp_789()) {
            if (param != class_7463.class_7464.field_39220) continue;
            return bound.comp_920();
        }
        return null;
    }

    @Nullable
    private static class_640 getPlayerInfo(@NotNull String name, class_634 connection, Map<String, class_640> profileNameCache, Map<String, class_640> nicknameCache) {
        class_640 player = ChatHeads.getPlayerFromProfileName(name = CONFIG.getProfileName(name).replaceAll(NON_NAME_REGEX, ""), connection, profileNameCache);
        if (player != null) {
            return player;
        }
        return ChatHeads.getPlayerFromNickname(name, connection, nicknameCache);
    }

    public static <V, K> V findByKey(Iterable<V> collection, Function<V, K> keyFunction, K key, @Nullable Map<K, V> cache) {
        if (cache != null && !cache.isEmpty()) {
            return cache.get(key);
        }
        for (V v : collection) {
            K k = keyFunction.apply(v);
            if (k == null) continue;
            if (key.equals(k)) {
                if (cache != null) {
                    cache.clear();
                }
                return v;
            }
            if (cache == null) continue;
            cache.put(k, v);
        }
        return null;
    }

    @Nullable
    public static class_640 getPlayerFromProfileName(@NotNull String word, class_634 connection, Map<String, class_640> profileNameCache) {
        return ChatHeads.findByKey(connection.method_2880(), playerInfo -> playerInfo.method_2966().getName().replaceAll(NON_NAME_REGEX, ""), word, profileNameCache);
    }

    @Nullable
    private static class_640 getPlayerFromNickname(@NotNull String word, class_634 connection, Map<String, class_640> nicknameCache) {
        return ChatHeads.findByKey(connection.method_2880(), playerInfo -> {
            class_2561 displayName = playerInfo.method_2971();
            return displayName != null ? displayName.getString().replaceAll(NON_NAME_REGEX, "") : null;
        }, word, nicknameCache);
    }

    public static class_1011 extractBlendedHead(class_1011 skin) {
        int xScale = skin.method_4307() / 64;
        int yScale = skin.method_4323() / 64;
        class_1011 head = new class_1011(8 * xScale, 8 * yScale, false);
        for (int y = 0; y < head.method_4323(); ++y) {
            for (int x = 0; x < head.method_4307(); ++x) {
                int headColor = skin.method_4315(8 * xScale + x, 8 * yScale + y);
                int hatColor = skin.method_4315(40 * xScale + x, 8 * yScale + y);
                head.method_4305(x, y, headColor);
                head.method_35624(x, y, hatColor);
            }
        }
        return head;
    }

    public static class_2960 getBlendedHeadLocation(class_2960 skinLocation) {
        return new class_2960(MOD_ID, skinLocation.method_12832());
    }

    public static void renderChatHead(class_332 guiGraphics, int x, int y, class_640 owner) {
        class_2960 skinLocation = owner.method_52810().comp_1626();
        if (blendedHeadTextures.contains(skinLocation)) {
            guiGraphics.method_25293(ChatHeads.getBlendedHeadLocation(skinLocation), x, y, 8, 8, 0.0f, 0.0f, 8, 8, 8, 8);
        } else {
            guiGraphics.method_25293(skinLocation, x, y, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.method_25293(skinLocation, x, y, 8, 8, 40.0f, 8.0f, 8, 8, 64, 64);
        }
    }

    static {
        lastY = 0;
        lastOpacity = 0.0f;
        serverSentUuid = false;
        serverDisabledChatHeads = false;
        blendedHeadTextures = new HashSet<class_2960>();
    }
}

