/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.renderdoc;

import com.qendolin.betterclouds.renderdoc.RenderDoc;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class CaptureManager {
    public static final Path LAUNCH_CONFIG_PATH = Path.of("./better-clouds/capture.conf", new String[0]);
    private static final List<Map.Entry<Long, Runnable>> callbacks = new ArrayList<Map.Entry<Long, Runnable>>();
    private static final AtomicLong frameIndex = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void capture(Consumer<RenderDoc.Capture> callback) {
        int captureIndex = RenderDoc.getNumCaptures();
        RenderDoc.triggerCapture();
        List<Map.Entry<Long, Runnable>> list = callbacks;
        synchronized (list) {
            callbacks.add(Map.entry(frameIndex.get() + 2L, () -> callback.accept(RenderDoc.getCapture(captureIndex))));
        }
    }

    public static void writeLaunchConfig(LaunchConfig config) throws IOException {
        Object str = "";
        str = (String)str + "load=" + config.load + "\n";
        str = (String)str + "once=" + config.once + "\n";
        str = (String)str + "expires=" + config.expires + "\n";
        Files.writeString(LAUNCH_CONFIG_PATH, (CharSequence)str, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static LaunchConfig readLaunchConfig() {
        try {
            List<String> confLines = Files.readAllLines(LAUNCH_CONFIG_PATH, StandardCharsets.UTF_8);
            Map<String, String> conf = confLines.stream().map(line -> line.split("=")).collect(Collectors.toMap(kvp -> kvp[0], kvp -> kvp[1]));
            boolean load = conf.get("load").equalsIgnoreCase("true");
            boolean once = conf.get("once").equalsIgnoreCase("true");
            long expires = Long.parseLong(conf.get("expires"));
            return new LaunchConfig(load, once, expires);
        }
        catch (Exception e) {
            return new LaunchConfig(false, false, 0L);
        }
    }

    public static void deleteLaunchConfig() {
        try {
            Files.delete(LAUNCH_CONFIG_PATH);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void onSwapBuffers() {
        long idx = frameIndex.getAndIncrement();
        if (callbacks.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Long, Runnable>> iterator = callbacks.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Runnable> entry = iterator.next();
            if (idx < entry.getKey()) continue;
            entry.getValue().run();
            iterator.remove();
        }
    }

    public record LaunchConfig(boolean load, boolean once, long expires) {
        public boolean isExpired() {
            return System.currentTimeMillis() >= this.expires;
        }
    }
}

