/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.mixin.optional.ExtendedShaderAccessor;
import com.qendolin.betterclouds.mixin.optional.FallbackShaderAccessor;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderKey;
import net.coderbot.iris.pipeline.newshader.fallback.FallbackShader;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_5944;

public class IrisCompat {
    public static final boolean IS_LOADED = FabricLoader.getInstance().isModLoaded("iris");
    private static final String INCOMPATIBLE_ERROR = "Incompatible Iris version for Better Clouds, please report this issue to Better Clouds. Details: ";

    public static boolean isShadersEnabled() {
        return IS_LOADED && Iris.getIrisConfig().areShadersEnabled() && Iris.getCurrentPack().isPresent();
    }

    public static void bindFramebuffer() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof NewWorldRenderingPipeline) {
            NewWorldRenderingPipeline corePipeline = (NewWorldRenderingPipeline)pipeline;
            class_5944 program = corePipeline.getShaderMap().getShader(ShaderKey.CLOUDS);
            GlFramebuffer before = null;
            GlFramebuffer after = null;
            if (program instanceof ExtendedShader) {
                ExtendedShader extended = (ExtendedShader)program;
                ExtendedShaderAccessor access = (ExtendedShaderAccessor)extended;
                before = access.getWritingToBeforeTranslucent();
                after = access.getWritingToAfterTranslucent();
            } else if (program instanceof FallbackShader) {
                FallbackShader fallback = (FallbackShader)program;
                FallbackShaderAccessor access = (FallbackShaderAccessor)fallback;
                before = access.getWritingToBeforeTranslucent();
                after = access.getWritingToAfterTranslucent();
            } else {
                throw new RuntimeException("Incompatible Iris version for Better Clouds, please report this issue to Better Clouds. Details: Shader is of type " + program.getClass() + ", Iris Version: " + Iris.getVersion());
            }
            GlFramebuffer required = corePipeline.isBeforeTranslucent ? before : after;
            if (required == null) {
                throw new RuntimeException("Incompatible Iris version for Better Clouds, please report this issue to Better Clouds. Details: Required framebuffer is null, Iris Version: " + Iris.getVersion());
            }
            if (corePipeline.isBeforeTranslucent) {
                before.bindAsDrawBuffer();
            } else {
                after.bindAsDrawBuffer();
            }
        }
    }
}

