/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.qendolin.betterclouds.Config;
import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.clouds.ChunkedGenerator;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.Mesh;
import com.qendolin.betterclouds.clouds.PrimitiveChangeDetector;
import com.qendolin.betterclouds.clouds.Resources;
import com.qendolin.betterclouds.compat.DistantHorizonsCompat;
import com.qendolin.betterclouds.compat.HeadInTheCloudsCompat;
import com.qendolin.betterclouds.compat.IrisCompat;
import com.qendolin.betterclouds.compat.WorldDuck;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_4063;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_5294;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_6854;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL32;

public class Renderer
implements AutoCloseable {
    private final class_310 client;
    private class_638 world = null;
    private float cloudsHeight;
    private int defaultFbo;
    private final Matrix4f mvpMatrix = new Matrix4f();
    private final Matrix4f mvMatrix = new Matrix4f();
    private final Matrix4f pMatrix = new Matrix4f();
    private final Matrix4f rotationProjectionMatrix = new Matrix4f();
    private final Matrix4f tempMatrix = new Matrix4f();
    private final Vector3f tempVector = new Vector3f();
    private final class_4604 tempFrustum = new class_4604(new Matrix4f().identity(), new Matrix4f().identity());
    private final PrimitiveChangeDetector shaderInvalidator = new PrimitiveChangeDetector(false);
    private final Resources res = new Resources();

    public Renderer(class_310 client) {
        this.client = client;
    }

    public void setWorld(class_638 world) {
        this.world = world;
    }

    public void reload(class_3300 manager) {
        Main.LOGGER.info("Reloading cloud renderer...");
        Main.LOGGER.debug("[1/6] Reloading shaders");
        this.res.reloadShaders(manager);
        Main.LOGGER.debug("[2/6] Reloading generator");
        this.res.reloadGenerator(this.isFancyMode());
        Main.LOGGER.debug("[3/6] Reloading textures");
        this.res.reloadTextures(this.client);
        Main.LOGGER.debug("[4/6] Reloading primitive meshes");
        this.res.reloadMeshPrimitives();
        Main.LOGGER.debug("[5/6] Reloading framebuffer");
        this.res.reloadFramebuffer(this.scaledFramebufferWidth(), this.scaledFramebufferHeight());
        Main.LOGGER.debug("[6/6] Reloading timers");
        this.res.reloadTimer();
        Main.LOGGER.info("Cloud renderer initialized");
    }

    private boolean isFancyMode() {
        return this.client.field_1690.method_1632() == class_4063.field_18164;
    }

    private int scaledFramebufferWidth() {
        return (int)(Main.getConfig().preset().upscaleResolutionFactor * (float)this.client.method_1522().field_1482);
    }

    private int scaledFramebufferHeight() {
        return (int)(Main.getConfig().preset().upscaleResolutionFactor * (float)this.client.method_1522().field_1481);
    }

    public PrepareResult prepare(class_4587 matrices, Matrix4f projMat, int ticks, float tickDelta, Vector3d cam) {
        assert (RenderSystem.isOnRenderThread());
        this.client.method_16011().method_15405("render_setup");
        Config config = Main.getConfig();
        if (this.res.failedToLoadCritical()) {
            if (RenderDoc.isFrameCapturing()) {
                Main.glCompat.debugMessage("prepare failed: critical resource not loaded");
            }
            return PrepareResult.FALLBACK;
        }
        if (!config.irisSupport && IrisCompat.IS_LOADED && IrisCompat.isShadersEnabled()) {
            if (RenderDoc.isFrameCapturing()) {
                Main.glCompat.debugMessage("prepare failed: iris support disabled");
            }
            return PrepareResult.FALLBACK;
        }
        if (this.client.field_1773.method_19418().method_19334() != class_5636.field_27888) {
            return PrepareResult.NO_RENDER;
        }
        class_5294 effects = this.world.method_28103();
        this.cloudsHeight = effects.method_28108();
        this.res.generator().bind();
        if (this.shaderInvalidator.hasChanged(this.client.field_1690.method_1632(), config.blockDistance(), Float.valueOf(config.fadeEdge), Float.valueOf(config.sizeXZ), Float.valueOf(config.sizeY), Main.glCompat.useDepthWriteFallback, Main.glCompat.useStencilTextureFallback, DistantHorizonsCompat.instance().isReady() && DistantHorizonsCompat.instance().isEnabled(), config.celestialBodyHalo)) {
            this.res.reloadShaders(this.client.method_1478());
        }
        this.res.generator().reallocateIfStale(config, this.isFancyMode());
        float raininess = Math.max(0.6f * this.getTrueRainGradient(tickDelta), this.getTrueThunderGradient(tickDelta));
        float cloudiness = raininess * 0.3f + 0.5f;
        this.res.generator().update(cam, (float)ticks + tickDelta, Main.getConfig(), cloudiness);
        if (this.res.generator().canGenerate() && !this.res.generator().generating() && !Debug.generatorPause) {
            this.client.method_16011().method_15405("generate_clouds");
            this.res.generator().generate();
            this.client.method_16011().method_15405("render_setup");
        }
        if (this.res.generator().canSwap()) {
            this.client.method_16011().method_15405("swap");
            this.res.generator().swap();
            this.client.method_16011().method_15405("render_setup");
        }
        this.tempMatrix.set((Matrix4fc)matrices.method_23760().method_23761());
        matrices.method_22904(this.res.generator().renderOriginX(cam.x), (double)this.cloudsHeight - cam.y, this.res.generator().renderOriginZ(cam.z));
        this.rotationProjectionMatrix.set((Matrix4fc)projMat);
        this.tempMatrix.m30(0.0f);
        this.tempMatrix.m31(0.0f);
        this.tempMatrix.m32(0.0f);
        this.tempMatrix.m33(0.0f);
        this.tempMatrix.m23(0.0f);
        this.tempMatrix.m13(0.0f);
        this.tempMatrix.m03(0.0f);
        this.rotationProjectionMatrix.mul((Matrix4fc)this.tempMatrix);
        this.pMatrix.set((Matrix4fc)projMat);
        this.mvMatrix.set((Matrix4fc)matrices.method_23760().method_23761());
        this.mvpMatrix.set((Matrix4fc)projMat);
        this.mvpMatrix.mul((Matrix4fc)this.mvMatrix);
        this.defaultFbo = GL32.glGetInteger((int)36006);
        return PrepareResult.RENDER;
    }

    public void render(int ticks, float tickDelta, Vector3d cam, Vector3d frustumPos, class_4604 frustum) {
        this.client.method_16011().method_15405("render_setup");
        if (Main.isProfilingEnabled()) {
            if (this.res.timer() == null) {
                this.res.reloadTimer();
            }
            this.res.timer().start();
        }
        Config config = Main.getConfig();
        if (this.isFramebufferStale()) {
            this.res.reloadFramebuffer(this.scaledFramebufferWidth(), this.scaledFramebufferHeight());
        }
        RenderSystem.viewport((int)0, (int)0, (int)this.res.fboWidth(), (int)this.res.fboHeight());
        GlStateManager._glBindFramebuffer((int)36009, (int)this.res.oitFbo());
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderSystem.clearDepth((double)1.0);
        this.client.method_16011().method_15405("draw_coverage");
        this.drawCoverage((float)ticks + tickDelta, cam, frustumPos, frustum);
        this.client.method_16011().method_15405("draw_shading");
        if (IrisCompat.IS_LOADED && IrisCompat.isShadersEnabled() && config.useIrisFBO) {
            IrisCompat.bindFramebuffer();
        } else {
            GlStateManager._glBindFramebuffer((int)36009, (int)this.defaultFbo);
        }
        this.drawShading(tickDelta);
        this.client.method_16011().method_15405("render_cleanup");
        this.res.generator().unbind();
        Resources.unbindShader();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
        RenderSystem.activeTexture((int)33984);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (!Main.glCompat.useStencilTextureFallback) {
            GL32.glDisable((int)2960);
            GL32.glStencilFunc((int)519, (int)0, (int)255);
            GL32.glStencilOp((int)7680, (int)7680, (int)7680);
        }
        if (Debug.frustumCulling) {
            Main.glCompat.pushDebugGroupDev("Frustum Culling Debug Draw");
            Debug.drawFrustumCulledBoxes(cam);
            Main.glCompat.popDebugGroupDev();
        }
        if (Main.isProfilingEnabled() && this.res.timer() != null) {
            this.res.timer().stop();
            if (this.res.timer().frames() >= Debug.profileInterval) {
                List<Double> times = this.res.timer().get();
                times.sort(Double::compare);
                double median = times.get(times.size() / 2);
                double p25 = times.get((int)Math.ceil((double)times.size() * 0.25));
                double p75 = times.get((int)Math.ceil((double)times.size() * 0.75));
                double min = times.get(0);
                double max = times.get(times.size() - 1);
                double average = times.stream().mapToDouble(d -> d).average().orElse(0.0);
                Main.debugChatMessage("profiling.gpuTimes", min, average, max, p25, median, p75);
                this.res.timer().reset();
            }
        }
    }

    private boolean isFramebufferStale() {
        return this.res.fboWidth() != this.scaledFramebufferWidth() || this.res.fboHeight() != this.scaledFramebufferHeight();
    }

    private void drawCoverage(float ticks, Vector3d cam, Vector3d frustumPos, class_4604 frustum) {
        RenderSystem.enableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
        if (Main.glCompat.useStencilTextureFallback) {
            RenderSystem.depthFunc((int)519);
            RenderSystem.enableBlend();
            RenderSystem.blendEquation((int)32774);
            Main.glCompat.blendFunci(0, 1, 0);
            Main.glCompat.blendFunci(1, 1, 1);
            GL32.glDisable((int)2960);
        } else {
            RenderSystem.depthFunc((int)513);
            RenderSystem.disableBlend();
            GL32.glEnable((int)2960);
            GL32.glStencilMask((int)255);
            GL32.glClearStencil((int)0);
            GL32.glStencilOp((int)7680, (int)7682, (int)7682);
            GL32.glStencilFunc((int)519, (int)255, (int)255);
        }
        if (this.isFancyMode()) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
        GL32.glClear((int)17664);
        Config generatorConfig = this.getGeneratorConfig();
        Config config = Main.getConfig();
        this.res.coverageShader().bind();
        this.res.coverageShader().uMVPMatrix.setMat4(this.mvpMatrix);
        this.res.coverageShader().uOriginOffset.setVec3((float)(-this.res.generator().renderOriginX(cam.x)), (float)cam.y - this.cloudsHeight, (float)(-this.res.generator().renderOriginZ(cam.z)));
        this.res.coverageShader().uBoundingBox.setVec4((float)cam.x, (float)cam.z, (float)generatorConfig.blockDistance() - (float)generatorConfig.chunkSize / 2.0f, generatorConfig.yRange + config.sizeY);
        this.res.coverageShader().uTime.setFloat(ticks / 20.0f);
        this.res.coverageShader().uMiscellaneous.setVec3(config.scaleFalloffMin, config.windEffectFactor, config.windSpeedFactor);
        class_6854 shape = RenderSystem.getShaderFogShape();
        if (shape == class_6854.field_36351) {
            this.res.coverageShader().uFogRange.setVec2(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        } else {
            this.res.coverageShader().uFogRange.setVec2(RenderSystem.getShaderFogStart(), RenderSystem.getShaderFogEnd());
        }
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)this.client.method_1522().method_30278());
        if (DistantHorizonsCompat.instance().isReady() && DistantHorizonsCompat.instance().isEnabled()) {
            this.res.coverageShader().uMVMatrix.setMat4(this.mvMatrix);
            this.res.coverageShader().uMcPMatrix.setMat4(this.pMatrix);
            Optional<Integer> depthId = DistantHorizonsCompat.instance().getDepthTextureId();
            RenderSystem.activeTexture((int)33990);
            if (depthId.isPresent()) {
                Matrix4f dhProjectionMatrix = DistantHorizonsCompat.instance().getProjectionMatrix();
                RenderSystem.bindTexture((int)depthId.get());
                this.res.coverageShader().uDhPMatrix.setMat4(dhProjectionMatrix);
            } else {
                RenderSystem.bindTexture((int)0);
                this.res.coverageShader().uDhPMatrix.setMat4(DistantHorizonsCompat.NOOP_MATRIX);
            }
        }
        RenderSystem.activeTexture((int)33989);
        this.client.method_1531().method_4619(Resources.NOISE_TEXTURE).method_23207();
        this.res.generator().bind();
        if (Main.glCompat.useBaseInstanceFallback) {
            this.res.generator().buffer().bindDrawBuffer();
        }
        this.setFrustumTo(this.tempFrustum, frustum);
        class_4604 frustumAtOrigin = this.tempFrustum;
        frustumAtOrigin.method_23088(frustumPos.x - this.res.generator().originX(), frustumPos.y, frustumPos.z - this.res.generator().originZ());
        Debug.clearFrustumCulledBoxed();
        if (!this.res.generator().canRender()) {
            RenderSystem.enableCull();
            return;
        }
        int runStart = -1;
        int runCount = 0;
        for (ChunkedGenerator.ChunkIndex chunk : this.res.generator().chunks()) {
            class_238 bounds = chunk.bounds(this.cloudsHeight, config.sizeXZ, config.sizeY);
            if (!frustumAtOrigin.method_23093(bounds)) {
                Debug.addFrustumCulledBox(bounds, false);
                if (runCount != 0) {
                    if (Main.glCompat.useBaseInstanceFallback) {
                        this.res.generator().buffer().setVAPointerToInstance(runStart);
                    }
                    Main.glCompat.drawArraysInstancedBaseInstanceFallback(5, 0, this.res.generator().instanceVertexCount(), runCount, runStart);
                }
                runStart = -1;
                runCount = 0;
                continue;
            }
            Debug.addFrustumCulledBox(bounds, true);
            if (runStart == -1) {
                runStart = chunk.start();
            }
            runCount += chunk.count();
        }
        if (runCount != 0) {
            if (Main.glCompat.useBaseInstanceFallback) {
                this.res.generator().buffer().setVAPointerToInstance(runStart);
            }
            Main.glCompat.drawArraysInstancedBaseInstanceFallback(5, 0, this.res.generator().instanceVertexCount(), runCount, runStart);
        }
        RenderSystem.enableCull();
    }

    private void drawShading(float tickDelta) {
        Config config = Main.getConfig();
        RenderSystem.depthFunc((int)513);
        if (!Main.glCompat.useDepthWriteFallback) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
        RenderSystem.enableBlend();
        RenderSystem.blendEquation((int)32774);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL32.glColorMaski((int)0, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (!Main.glCompat.useStencilTextureFallback) {
            GL32.glDisable((int)2960);
        }
        RenderSystem.activeTexture((int)33985);
        if (Main.glCompat.useDepthWriteFallback) {
            RenderSystem.bindTexture((int)0);
        } else {
            RenderSystem.bindTexture((int)this.res.oitCoverageDepthTexture());
        }
        RenderSystem.activeTexture((int)33986);
        RenderSystem.bindTexture((int)this.res.oitDataTexture());
        RenderSystem.activeTexture((int)33987);
        RenderSystem.bindTexture((int)this.res.oitCoverageTexture());
        RenderSystem.activeTexture((int)33988);
        this.client.method_1531().method_4619(Resources.LIGHTING_TEXTURE).method_23207();
        float effectLuma = this.getEffectLuminance(tickDelta);
        long skyTime = this.world.method_30271() % 24000L;
        float skyAngleRad = this.world.method_8442(tickDelta);
        float sunPathAngleRad = (float)Math.toRadians(config.preset().sunPathAngle);
        float dayNightFactor = this.interpolateDayNightFactor(skyTime, config.preset().sunriseStartTime, config.preset().sunriseEndTime, config.preset().sunsetStartTime, config.preset().sunsetEndTime);
        float brightness = (1.0f - dayNightFactor) * config.preset().nightBrightness + dayNightFactor * config.preset().dayBrightness;
        float sunAxisY = class_3532.method_15374((float)sunPathAngleRad);
        float sunAxisZ = class_3532.method_15362((float)sunPathAngleRad);
        Vector3f sunDir = this.tempVector.set(1.0f, 0.0f, 0.0f).rotateAxis(skyAngleRad + 1.5707964f, 0.0f, sunAxisY, sunAxisZ);
        this.res.shadingShader().bind();
        this.res.shadingShader().uVPMatrix.setMat4(this.rotationProjectionMatrix);
        this.res.shadingShader().uSunDirection.setVec4(sunDir.x, sunDir.y, sunDir.z, (float)(this.world.method_8532() % 24000L) / 24000.0f);
        this.res.shadingShader().uSunAxis.setVec3(0.0f, sunAxisY, sunAxisZ);
        this.res.shadingShader().uOpacity.setVec3(config.preset().opacity, config.preset().opacityFactor, config.preset().opacityExponent);
        this.res.shadingShader().uColorGrading.setVec4(brightness, 1.0f / config.preset().gamma(), effectLuma, config.preset().saturation);
        this.res.shadingShader().uTint.setVec3(config.preset().tintRed, config.preset().tintGreen, config.preset().tintBlue);
        this.res.shadingShader().uNoiseFactor.setFloat(config.colorVariationFactor);
        GL32.glBindVertexArray((int)this.res.cubeVao());
        GL32.glDrawArrays((int)4, (int)0, (int)Mesh.CUBE_MESH_VERTEX_COUNT);
        if (Main.glCompat.useDepthWriteFallback) {
            RenderSystem.activeTexture((int)33990);
            RenderSystem.bindTexture((int)this.res.oitCoverageDepthTexture());
            GL32.glTexParameteri((int)3553, (int)Main.glCompat.GL_DEPTH_STENCIL_TEXTURE_MODE, (int)6402);
            this.res.depthShader().bind();
            GL32.glDrawArrays((int)4, (int)0, (int)6);
            GL32.glTexParameteri((int)3553, (int)Main.glCompat.GL_DEPTH_STENCIL_TEXTURE_MODE, (int)6401);
        }
    }

    private Config getGeneratorConfig() {
        Config config = this.res.generator().config();
        if (config != null) {
            return config;
        }
        return Main.getConfig();
    }

    private void setFrustumTo(class_4604 dst, class_4604 src) {
        dst.field_40823 = src.field_40823;
        dst.field_40824.set((Matrix4fc)src.field_40824);
        dst.field_20995 = src.field_20995;
        dst.field_20996 = src.field_20996;
        dst.field_20997 = src.field_20997;
        dst.field_34821 = src.field_34821;
    }

    private float getEffectLuminance(float tickDelta) {
        float thunder;
        float luma = 1.0f;
        float rain = this.world.method_8430(tickDelta);
        if (rain > 0.0f) {
            float f = rain * 0.95f;
            luma *= 1.0f - f + f * 0.6f;
        }
        if ((thunder = this.world.method_8478(tickDelta)) > 0.0f) {
            float f = thunder * 0.95f;
            luma *= 1.0f - f + f * 0.2f;
        }
        return luma;
    }

    private float getTrueRainGradient(float tickDelta) {
        if (HeadInTheCloudsCompat.IS_LOADED) {
            return ((WorldDuck)this.world).betterclouds$getOriginalRainGradient(tickDelta);
        }
        return this.world.method_8430(tickDelta);
    }

    private float getTrueThunderGradient(float tickDelta) {
        if (HeadInTheCloudsCompat.IS_LOADED) {
            return ((WorldDuck)this.world).betterclouds$getOriginalThunderGradient(tickDelta);
        }
        return this.world.method_8478(tickDelta);
    }

    private float interpolateDayNightFactor(float time, float riseStart, float riseEnd, float setStart, float setEnd) {
        if (time <= 6000.0f || time > 18000.0f) {
            if (time > 18000.0f) {
                time -= 24000.0f;
            }
            return this.smoothstep(time, riseStart, riseEnd);
        }
        return 1.0f - this.smoothstep(time, setStart, setEnd);
    }

    private float smoothstep(float x, float e0, float e1) {
        x = class_3532.method_15363((float)((x - e0) / (e1 - e0)), (float)0.0f, (float)1.0f);
        return x * x * (3.0f - 2.0f * x);
    }

    @Override
    public void close() {
        this.res.close();
    }

    public static enum PrepareResult {
        RENDER,
        NO_RENDER,
        FALLBACK;

    }
}

