/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL33;

public class GlTimer
implements AutoCloseable {
    private int query;
    private int queryWaiting;
    private boolean first = true;
    private int accumFrames = 0;
    private List<Double> history = new ArrayList<Double>();

    public GlTimer() {
        this.query = GL33.glGenQueries();
        this.queryWaiting = GL33.glGenQueries();
    }

    public void start() {
        GL33.glBeginQuery((int)35007, (int)this.query);
    }

    public void stop() {
        GL33.glEndQuery((int)35007);
        int done = this.queryWaiting;
        this.queryWaiting = this.query;
        this.query = done;
        if (this.first) {
            this.first = false;
            return;
        }
        long ns = GL33.glGetQueryObjectui64((int)done, (int)34918);
        this.history.add((double)ns / 1000000.0);
        ++this.accumFrames;
    }

    public List<Double> get() {
        return this.history;
    }

    public int frames() {
        return this.accumFrames;
    }

    public void reset() {
        this.history = new ArrayList<Double>();
        this.accumFrames = 0;
    }

    @Override
    public void close() {
        GL33.glDeleteQueries((int[])new int[]{this.query, this.queryWaiting});
    }
}

