/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.google.common.base.Objects;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.qendolin.betterclouds.ShaderPresetLoader;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_151;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_7134;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    public static final String DEFAULT_PRESET_KEY = "default";
    public static final InstanceCreator<Config> INSTANCE_CREATOR = type -> new Config();
    public static final RegistryKeySerializer REGISTRY_KEY_SERIALIZER = new RegistryKeySerializer();
    @SerialEntry
    public boolean enabled = true;
    @SerialEntry
    public float distance = 4.0f;
    @SerialEntry
    public float randomPlacement = 1.0f;
    @SerialEntry
    public float fuzziness = 1.0f;
    @SerialEntry
    public boolean shuffle = false;
    @SerialEntry
    public float yRange = 64.0f;
    @SerialEntry
    public float yOffset = 0.0f;
    @SerialEntry
    public float sparsity = 0.0f;
    @SerialEntry
    public float spacing = 5.25f;
    @SerialEntry
    public float sizeXZ = 16.0f;
    @SerialEntry
    public float sizeY = 8.0f;
    @SerialEntry
    public float travelSpeed = 0.03f;
    @SerialEntry
    public float windEffectFactor = 1.0f;
    @SerialEntry
    public float windSpeedFactor = 1.0f;
    @SerialEntry
    public float colorVariationFactor = 1.0f;
    @SerialEntry
    public boolean celestialBodyHalo = true;
    @SerialEntry
    public int chunkSize = 32;
    @SerialEntry
    public float samplingScale = 1.0f;
    @SerialEntry
    public float scaleFalloffMin = 0.25f;
    @SerialEntry
    public float fadeEdge = 0.15f;
    @SerialEntry
    public boolean usePersistentBuffers = true;
    @SerialEntry
    public boolean irisSupport = true;
    @SerialEntry
    public boolean cloudOverride = true;
    @SerialEntry
    public boolean useIrisFBO = true;
    @SerialEntry
    public int selectedPreset = 0;
    @SerialEntry
    public List<ShaderConfigPreset> presets = new ArrayList<ShaderConfigPreset>();
    @SerialEntry
    public int lastTelemetryVersion = 0;
    @SerialEntry
    public boolean gpuIncompatibleMessageEnabled = true;
    @SerialEntry
    public List<class_5321<class_2874>> enabledDimensions = new ArrayList<class_5321>(List.of(class_7134.field_37666));

    public Config() {
    }

    public Config(Config other) {
        this.distance = other.distance;
        this.randomPlacement = other.randomPlacement;
        this.fuzziness = other.fuzziness;
        this.shuffle = other.shuffle;
        this.yRange = other.yRange;
        this.yOffset = other.yOffset;
        this.sparsity = other.sparsity;
        this.spacing = other.spacing;
        this.sizeXZ = other.sizeXZ;
        this.sizeY = other.sizeY;
        this.travelSpeed = other.travelSpeed;
        this.windEffectFactor = other.windEffectFactor;
        this.windSpeedFactor = other.windSpeedFactor;
        this.colorVariationFactor = other.colorVariationFactor;
        this.chunkSize = other.chunkSize;
        this.samplingScale = other.samplingScale;
        this.scaleFalloffMin = other.scaleFalloffMin;
        this.fadeEdge = other.fadeEdge;
        this.usePersistentBuffers = other.usePersistentBuffers;
        this.irisSupport = other.irisSupport;
        this.enabled = other.enabled;
        this.cloudOverride = other.cloudOverride;
        this.useIrisFBO = other.useIrisFBO;
        this.selectedPreset = other.selectedPreset;
        this.presets = other.presets;
        this.presets.replaceAll(ShaderConfigPreset::new);
        this.lastTelemetryVersion = other.lastTelemetryVersion;
        this.gpuIncompatibleMessageEnabled = other.gpuIncompatibleMessageEnabled;
        this.enabledDimensions = other.enabledDimensions;
        this.celestialBodyHalo = other.celestialBodyHalo;
    }

    public void loadDefaultPresets() {
        String selectedDefaultPreset = this.preset().key;
        HashMap<String, ShaderConfigPreset> defaults = new HashMap<String, ShaderConfigPreset>(ShaderPresetLoader.INSTANCE.presets());
        boolean missingDefault = this.presets.stream().noneMatch(preset -> DEFAULT_PRESET_KEY.equals(preset.key));
        this.presets.removeIf(preset -> preset.key != null && !preset.editable && defaults.containsKey(preset.key));
        this.presets.addAll(defaults.values());
        if (selectedDefaultPreset != null) {
            this.presets.stream().filter(preset -> selectedDefaultPreset.equals(preset.key)).findFirst().ifPresentOrElse(prevSelectedPreset -> {
                this.selectedPreset = this.presets.indexOf(prevSelectedPreset);
            }, () -> {
                this.selectedPreset = 0;
            });
        }
        if (missingDefault) {
            this.presets.removeIf(Config::isPresetEqualToEmpty);
            ShaderConfigPreset defaultPreset = (ShaderConfigPreset)defaults.get(DEFAULT_PRESET_KEY);
            if (defaultPreset != null) {
                ShaderConfigPreset defaultCopy = new ShaderConfigPreset(defaultPreset);
                defaultCopy.markAsCopy();
                this.presets.add(defaultCopy);
                this.selectedPreset = this.presets.indexOf(defaultCopy);
            }
        }
        this.sortPresets();
    }

    @NotNull
    public ShaderConfigPreset preset() {
        if (this.presets.isEmpty()) {
            this.addFirstPreset();
        }
        this.selectedPreset = class_3532.method_15340((int)this.selectedPreset, (int)0, (int)(this.presets.size() - 1));
        return this.presets.get(this.selectedPreset);
    }

    private static boolean isPresetEqualToEmpty(ShaderConfigPreset preset) {
        if (preset == null) {
            return true;
        }
        String title = preset.title;
        preset.title = ShaderConfigPreset.EMPTY_PRESET.title;
        boolean equal = preset.isEqualTo(ShaderConfigPreset.EMPTY_PRESET);
        preset.title = title;
        return equal;
    }

    public void sortPresets() {
        ShaderConfigPreset selected = this.preset();
        Comparator<ShaderConfigPreset> comparator = Comparator.comparing(preset -> !preset.editable).thenComparing(preset -> !DEFAULT_PRESET_KEY.equals(preset.key)).thenComparing(preset -> preset.title);
        this.presets.sort(comparator);
        this.selectedPreset = this.presets.indexOf(selected);
    }

    public void addFirstPreset() {
        if (!this.presets.isEmpty()) {
            return;
        }
        this.presets.add(new ShaderConfigPreset());
    }

    public int blockDistance() {
        return (int)(this.distance * (float)((Integer)class_310.method_1551().field_1690.method_42503().method_41753()).intValue() * 16.0f);
    }

    public static class ShaderConfigPreset {
        public static final InstanceCreator<ShaderConfigPreset> INSTANCE_CREATOR = type -> new ShaderConfigPreset();
        protected static final ShaderConfigPreset EMPTY_PRESET = new ShaderConfigPreset();
        @SerialEntry
        public String title;
        @SerialEntry
        @Nullable
        public String key;
        @SerialEntry
        public boolean editable = true;
        @SerialEntry
        public float upscaleResolutionFactor = 1.0f;
        @SerialEntry
        public float gamma = 1.0f;
        @SerialEntry
        public float sunPathAngle = 0.0f;
        @SerialEntry
        public int sunriseStartTime = -785;
        @SerialEntry
        public int sunriseEndTime = 1163;
        @SerialEntry
        public int sunsetStartTime = 10837;
        @SerialEntry
        public int sunsetEndTime = 12785;
        @SerialEntry
        public float dayBrightness = 1.0f;
        @SerialEntry
        public float nightBrightness = 1.0f;
        @SerialEntry
        public float saturation = 1.0f;
        @SerialEntry
        public float opacity = 0.2f;
        @SerialEntry
        public float opacityFactor = 1.0f;
        @SerialEntry
        public float opacityExponent = 1.5f;
        @SerialEntry
        public float tintRed = 1.0f;
        @SerialEntry
        public float tintGreen = 1.0f;
        @SerialEntry
        public float tintBlue = 1.0f;

        public ShaderConfigPreset() {
            this("");
        }

        public ShaderConfigPreset(String title) {
            this.title = title;
        }

        public ShaderConfigPreset(ShaderConfigPreset other) {
            this.title = other.title;
            this.key = other.key;
            this.editable = other.editable;
            this.upscaleResolutionFactor = other.upscaleResolutionFactor;
            this.gamma = other.gamma;
            this.sunPathAngle = other.sunPathAngle;
            this.dayBrightness = other.dayBrightness;
            this.nightBrightness = other.nightBrightness;
            this.sunriseStartTime = other.sunriseStartTime;
            this.sunriseEndTime = other.sunriseEndTime;
            this.sunsetStartTime = other.sunsetStartTime;
            this.sunsetEndTime = other.sunsetEndTime;
            this.saturation = other.saturation;
            this.opacity = other.opacity;
            this.opacityFactor = other.opacityFactor;
            this.opacityExponent = other.opacityExponent;
            this.tintRed = other.tintRed;
            this.tintGreen = other.tintGreen;
            this.tintBlue = other.tintBlue;
        }

        public float gamma() {
            if (this.gamma > 0.0f) {
                return this.gamma;
            }
            return -1.0f / this.gamma;
        }

        public void markAsCopy() {
            this.editable = true;
            this.key = null;
        }

        public boolean isEqualTo(ShaderConfigPreset other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            return this.editable == other.editable && Float.compare(other.upscaleResolutionFactor, this.upscaleResolutionFactor) == 0 && Float.compare(other.gamma, this.gamma) == 0 && Float.compare(other.sunPathAngle, this.sunPathAngle) == 0 && this.sunriseStartTime == other.sunriseStartTime && this.sunriseEndTime == other.sunriseEndTime && this.sunsetStartTime == other.sunsetStartTime && this.sunsetEndTime == other.sunsetEndTime && Float.compare(other.dayBrightness, this.dayBrightness) == 0 && Float.compare(other.nightBrightness, this.nightBrightness) == 0 && Float.compare(other.saturation, this.saturation) == 0 && Float.compare(other.opacity, this.opacity) == 0 && Float.compare(other.opacityFactor, this.opacityFactor) == 0 && Float.compare(other.opacityExponent, this.opacityExponent) == 0 && Float.compare(other.tintRed, this.tintRed) == 0 && Float.compare(other.tintGreen, this.tintGreen) == 0 && Float.compare(other.tintBlue, this.tintBlue) == 0 && Objects.equal((Object)this.title, (Object)other.title) && Objects.equal((Object)this.key, (Object)other.key);
        }
    }

    public static class RegistryKeySerializer
    implements JsonSerializer<class_5321<class_2874>>,
    JsonDeserializer<class_5321<class_2874>> {
        private RegistryKeySerializer() {
        }

        public class_5321<class_2874> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("RegistryKey must be a string");
            }
            try {
                class_2960 id = new class_2960(json.getAsString());
                return class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)id);
            }
            catch (class_151 e) {
                throw new JsonParseException("Invalid RegistryKey: " + e.getMessage());
            }
        }

        public JsonElement serialize(class_5321<class_2874> src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.method_29177().toString());
        }
    }
}

