/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.advancementinfo;

import de.guntram.mcmod.advancementinfo.AdvancementStep;
import de.guntram.mcmod.advancementinfo.ModConfig;
import de.guntram.mcmod.advancementinfo.accessors.AdvancementScreenAccessor;
import de.guntram.mcmod.advancementinfo.accessors.AdvancementWidgetAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1269;
import net.minecraft.class_167;
import net.minecraft.class_185;
import net.minecraft.class_2960;
import net.minecraft.class_454;
import net.minecraft.class_456;
import net.minecraft.class_457;
import net.minecraft.class_632;
import net.minecraft.class_8781;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class AdvancementInfo
implements ClientModInitializer {
    static final String MODID = "advancementinfo";
    static final String VERSION = "@VERSION@";
    static final Logger LOGGER = LogManager.getLogger();
    public static class_456 mouseOver;
    public static class_456 mouseClicked;
    public static List<AdvancementStep> cachedClickList;
    public static int cachedClickListLineCount;
    public static boolean showAll;
    public static ModConfig config;

    public static List<AdvancementStep> getSteps(AdvancementWidgetAccessor widget) {
        ArrayList<AdvancementStep> result = new ArrayList<AdvancementStep>();
        AdvancementInfo.addStep(result, widget.getProgress(), widget.getProgress().method_731(), false);
        AdvancementInfo.addStep(result, widget.getProgress(), widget.getProgress().method_734(), true);
        return result;
    }

    private static void addStep(List<AdvancementStep> result, class_167 progress, Iterable<String> criteria, boolean obtained) {
        String[] prefixes = new String[]{"item.minecraft", "block.minecraft", "entity.minecraft", "container", "effect.minecraft", "biome.minecraft"};
        ArrayList<String> sorted = new ArrayList<String>();
        for (String s : criteria) {
            sorted.add(s);
        }
        List<String> details = null;
        Collections.sort(sorted);
        for (String s : sorted) {
            String translation = null;
            String key = s;
            if (key.startsWith("minecraft:")) {
                key = key.substring(10);
            }
            if (key.startsWith("armor_trimmed_minecraft:")) {
                key = key.substring(24);
            }
            if (key.startsWith("textures/entity/")) {
                String entityAppearance = key.substring(16);
                int dotPos = entityAppearance.indexOf(".");
                if (dotPos > 0) {
                    entityAppearance = entityAppearance.substring(0, dotPos);
                }
                translation = entityAppearance;
            }
            if (translation == null) {
                for (String prefix : prefixes) {
                    if (!class_1074.method_4663((String)(prefix + "." + key))) continue;
                    translation = class_1074.method_4662((String)(prefix + "." + key), (Object[])new Object[0]);
                    break;
                }
            }
            if (translation == null) {
                translation = key;
            }
            result.add(new AdvancementStep(translation, obtained, details));
        }
    }

    public static void setMatchingFrom(class_457 screen, String text) {
        ArrayList<AdvancementStep> result = new ArrayList<AdvancementStep>();
        class_632 advancementHandler = ((AdvancementScreenAccessor)screen).getAdvancementHandler();
        Collection all = advancementHandler.method_53814().method_53693();
        int lineCount = 0;
        text = text.toLowerCase();
        for (class_8781 adv : all) {
            class_2960 id = adv.method_53649().comp_1919();
            if (id.method_12832().startsWith("recipes/")) continue;
            Optional display = adv.method_53647().comp_1913();
            if (display.isEmpty()) {
                LOGGER.debug("! {} Has no display", (Object)id);
                continue;
            }
            if (((class_185)display.get()).method_811() == null) {
                LOGGER.debug("! {} Has no title", (Object)id);
                continue;
            }
            if (((class_185)display.get()).method_817() == null) {
                LOGGER.debug("! {} Has no description", (Object)id);
                continue;
            }
            String title = ((class_185)display.get()).method_811().getString();
            String desc = ((class_185)display.get()).method_817().getString();
            LOGGER.debug("- {} {}: {} ", (Object)id, (Object)title, (Object)desc);
            if (!title.toLowerCase().contains(text) && !desc.toLowerCase().contains(text)) continue;
            ArrayList<String> details = new ArrayList<String>();
            details.add(desc);
            class_454 tab = ((AdvancementScreenAccessor)screen).myGetTab(adv);
            if (tab == null) {
                LOGGER.info("no tab found for advancement {} title {} description {}", (Object)id, (Object)title, (Object)desc);
                continue;
            }
            details.add(tab.method_2309().getString());
            boolean done = ((AdvancementWidgetAccessor)screen.method_2335(adv)).getProgress().method_740();
            result.add(new AdvancementStep(title, done, details));
            lineCount += 3;
        }
        cachedClickList = result;
        cachedClickListLineCount = lineCount;
        mouseOver = null;
    }

    public void onInitializeClient() {
        Configurator.setLevel((String)LOGGER.getName(), (Level)Level.ALL);
        showAll = false;
        if (FabricLoader.getInstance().isModLoaded("cloth-config2")) {
            ConfigHolder configHolder = AutoConfig.register(ModConfig.class, JanksonConfigSerializer::new);
            configHolder.registerSaveListener((holder, modConfig) -> {
                modConfig.validate();
                return class_1269.field_5811;
            });
            config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        } else {
            config = new ModConfig();
        }
        LOGGER.info("AdvancementInfo initialized");
    }
}

