/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.fastpaintings;

import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.fastpaintings.DropMode;
import net.mehvahdjukaar.fastpaintings.FastPaintings;
import net.mehvahdjukaar.fastpaintings.PaintingBlockEntity;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.class_1264;
import net.minecraft.class_1530;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_6880;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaintingBlock
extends WaterBlock
implements class_2343 {
    protected static final class_265 SHAPE_NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SHAPE_SOUTH = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH, (class_2350)class_2350.field_11035);
    protected static final class_265 SHAPE_EAST = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH, (class_2350)class_2350.field_11034);
    protected static final class_265 SHAPE_WEST = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH, (class_2350)class_2350.field_11039);
    protected static final class_2753 FACING = class_2741.field_12481;
    protected static final class_2758 DOWN_OFFSET = class_2758.method_11867((String)"y_offset", (int)0, (int)5);
    protected static final class_2758 RIGHT_OFFSET = class_2758.method_11867((String)"x_offset", (int)0, (int)5);

    public PaintingBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)DOWN_OFFSET, (Comparable)Integer.valueOf(0))).method_11657((class_2769)RIGHT_OFFSET, (Comparable)Integer.valueOf(0))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
        DropMode mode = FastPaintings.SPECIAL_DROP.get();
        if (mode != DropMode.OFF && PaintingBlock.isMaster(state)) {
            PaintingBlockEntity m = PaintingBlock.getMaster(state, pos, (class_1920)level);
            class_1799 itemStack = new class_1799((class_1935)class_1802.field_8892);
            if (m != null && (mode == DropMode.ALWAYS || m.isPlacedWithNbt())) {
                class_2487 compoundTag = itemStack.method_7911("EntityTag");
                class_1534.method_48928((class_2487)compoundTag, m.getVariant());
            }
            class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)itemStack);
        }
        super.method_9536(state, level, pos, newState, movedByPiston);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 params) {
        if (FastPaintings.SPECIAL_DROP.get() != DropMode.OFF) {
            return List.of();
        }
        return super.method_9560(state, params);
    }

    public boolean method_9538(class_2680 blockState) {
        return true;
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_3727 ec;
        if (context instanceof class_3727 && !((ec = (class_3727)context).method_32480() instanceof class_1530)) {
            return class_259.method_1073();
        }
        return super.method_9549(state, level, pos, context);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, DOWN_OFFSET, RIGHT_OFFSET});
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 collisionContext) {
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            default -> SHAPE_NORTH;
            case class_2350.field_11035 -> SHAPE_SOUTH;
            case class_2350.field_11039 -> SHAPE_WEST;
            case class_2350.field_11034 -> SHAPE_EAST;
        };
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 updateDir, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        class_2350 dir = (class_2350)stateIn.method_11654((class_2769)FACING);
        if (updateDir.method_10153() == dir && !facingState.method_51367() && !class_2312.method_9999((class_2680)facingState)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(stateIn, updateDir, facingState, worldIn, currentPos, facingPos);
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        PaintingBlockEntity m = PaintingBlock.getMaster(state, pos, (class_1920)level);
        if (m != null) {
            pos = m.method_11016();
            class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
            class_6880<class_1535> variant = m.getVariant();
            int width = PaintingBlock.getWidth(variant);
            int height = PaintingBlock.getHeight(variant);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    class_2338 p = pos.method_10087(y).method_10079(dir.method_10160(), x);
                    class_2680 b = level.method_8320(p);
                    if (b.method_27852((class_2248)this) && b.method_11654((class_2769)FACING) == dir && (Integer)b.method_11654((class_2769)DOWN_OFFSET) == y && (Integer)b.method_11654((class_2769)RIGHT_OFFSET) == x) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.method_9612(state, level, pos, block, fromPos, isMoving);
        if (!this.method_9558(state, (class_4538)level, pos)) {
            PaintingBlockEntity m = PaintingBlock.getMaster(state, pos, (class_1920)level);
            if (m != null) {
                pos = m.method_11016();
                class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
                class_6880<class_1535> variant = m.getVariant();
                int width = PaintingBlock.getWidth(variant);
                int height = PaintingBlock.getHeight(variant);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        class_2338 p = pos.method_10087(y).method_10079(dir.method_10160(), x);
                        if (!level.method_8320(p).method_27852((class_2248)this)) continue;
                        level.method_8650(p, false);
                    }
                }
            } else {
                level.method_8650(pos, false);
            }
        }
    }

    private static int getHeight(class_6880<class_1535> variant) {
        return ((class_1535)variant.comp_349()).method_6943() / 16;
    }

    private static int getWidth(class_6880<class_1535> variant) {
        return ((class_1535)variant.comp_349()).method_6945() / 16;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return PaintingBlock.isMaster(state) ? new PaintingBlockEntity(pos, state) : null;
    }

    public class_1799 method_9574(class_4538 levelReader, class_2338 blockPos, class_2680 blockState) {
        return class_1802.field_8892.method_7854();
    }

    public static boolean tryConverting(class_1534 entity, @Nullable class_1799 stack) {
        class_2338 p;
        class_1937 level = entity.method_37908();
        class_2350 dir = entity.method_5735();
        class_6880 variant = entity.method_43404();
        int width = PaintingBlock.getWidth((class_6880<class_1535>)variant);
        int height = PaintingBlock.getHeight((class_6880<class_1535>)variant);
        if (width > 5 || height > 5) {
            return false;
        }
        class_238 bb = entity.method_5829();
        class_2338 pos = switch (dir) {
            default -> class_2338.method_49637((double)(bb.field_1320 - 0.5), (double)(bb.field_1325 - 0.5), (double)bb.field_1321);
            case class_2350.field_11035 -> class_2338.method_49637((double)bb.field_1323, (double)(bb.field_1325 - 0.5), (double)bb.field_1324);
            case class_2350.field_11039 -> class_2338.method_49637((double)bb.field_1323, (double)(bb.field_1325 - 0.5), (double)bb.field_1321);
            case class_2350.field_11034 -> class_2338.method_49637((double)bb.field_1320, (double)(bb.field_1325 - 0.5), (double)(bb.field_1324 - 0.5));
        };
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                p = pos.method_10087(y).method_10079(dir.method_10160(), x);
                if (level.method_8320(p).method_26215()) continue;
                return false;
            }
        }
        if (level.method_8320(pos).method_26215()) {
            class_2680 state = (class_2680)FastPaintings.PAINTING_BLOCK.get().method_9564().method_11657((class_2769)FACING, (Comparable)dir);
            level.method_8652(pos, state, 2);
            p = level.method_8321(pos);
            if (p instanceof PaintingBlockEntity) {
                class_2487 tag;
                Optional variant2;
                PaintingBlockEntity pe = (PaintingBlockEntity)p;
                pe.setVariant((class_6880<class_1535>)variant);
                if (stack != null && stack.method_7985() && (variant2 = class_1534.method_48929((class_2487)(tag = stack.method_7941("EntityTag")))).isPresent() && ((class_6880)variant2.get()).comp_349() == variant.comp_349()) {
                    pe.setPlacedWithNbt(true);
                }
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        if (x == 0 && y == 0) continue;
                        class_2338 p2 = pos.method_10087(y).method_10079(dir.method_10160(), x);
                        level.method_8652(p2, (class_2680)((class_2680)state.method_11657((class_2769)DOWN_OFFSET, (Comparable)Integer.valueOf(y))).method_11657((class_2769)RIGHT_OFFSET, (Comparable)Integer.valueOf(x)), 2);
                    }
                }
                pe.requestModelReload();
                entity.method_31472();
                return true;
            }
        }
        return false;
    }

    public static boolean isMaster(class_2680 state) {
        return (Integer)state.method_11654((class_2769)DOWN_OFFSET) == 0 && (Integer)state.method_11654((class_2769)RIGHT_OFFSET) == 0;
    }

    public static PaintingBlockEntity getMaster(class_2680 state, class_2338 pos, class_1920 level) {
        class_1937 l;
        class_2338 masterPos = PaintingBlock.getMasterPos(state, pos);
        if (level instanceof class_1937 && !(l = (class_1937)level).method_8477(pos)) {
            return null;
        }
        class_2586 e = level.method_8321(masterPos);
        if (e instanceof PaintingBlockEntity) {
            PaintingBlockEntity pe = (PaintingBlockEntity)e;
            return pe;
        }
        return null;
    }

    @NotNull
    private static class_2338 getMasterPos(class_2680 state, class_2338 pos) {
        int y = (Integer)state.method_11654((class_2769)DOWN_OFFSET);
        int x = (Integer)state.method_11654((class_2769)RIGHT_OFFSET);
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        return pos.method_10086(y).method_10079(facing.method_10170(), x);
    }

    public boolean method_9522(class_2680 state, class_2680 adjacentBlockState, class_2350 direction) {
        if (adjacentBlockState.method_27852((class_2248)this) && adjacentBlockState.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING)) {
            return true;
        }
        return state.method_11654((class_2769)FACING) == direction || super.method_9522(state, adjacentBlockState, direction);
    }
}

