/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.compat;

import com.google.common.collect.Table;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.FloatFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.LongFieldBuilder;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.BalmConfigProperty;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ClothConfigUtils {
    public static <T extends BalmConfigData> ConfigScreenFactory<?> getConfigScreen(Class<T> clazz) {
        return screen -> {
            String configName = Balm.getConfig().getConfigName(clazz);
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(screen).setTitle((class_2561)class_2561.method_43471((String)("config." + configName + ".title")));
            builder.setSavingRunnable(() -> Balm.getConfig().saveBackingConfig(clazz));
            Table<String, String, BalmConfigProperty<?>> properties = Balm.getConfig().getConfigProperties(clazz);
            for (String category : properties.rowKeySet()) {
                String categoryI18nBase = category.isEmpty() ? "config." + configName : "config." + configName + "." + category;
                class_5250 categoryDisplayName = class_2561.method_43471((String)categoryI18nBase);
                ConfigCategory categoryInstance = builder.getOrCreateCategory((class_2561)categoryDisplayName);
                for (Map.Entry entry : properties.row((Object)category).entrySet()) {
                    String property = (String)entry.getKey();
                    class_5250 displayName = class_2561.method_43471((String)(categoryI18nBase + "." + property));
                    class_5250 tooltip = class_2561.method_43471((String)(categoryI18nBase + "." + property + ".tooltip"));
                    BalmConfigProperty backingProperty = (BalmConfigProperty)entry.getValue();
                    if (backingProperty.getType() == String.class) {
                        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startStrField((class_2561)displayName, (String)backingProperty.getValue()).setDefaultValue((String)backingProperty.getDefaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (backingProperty.getType() == Integer.class || backingProperty.getType() == Integer.TYPE) {
                        categoryInstance.addEntry((AbstractConfigListEntry)((IntFieldBuilder)builder.entryBuilder().startIntField((class_2561)displayName, ((Integer)backingProperty.getValue()).intValue()).setDefaultValue((Object)((Integer)backingProperty.getDefaultValue()))).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (backingProperty.getType() == Long.class || backingProperty.getType() == Long.TYPE) {
                        categoryInstance.addEntry((AbstractConfigListEntry)((LongFieldBuilder)builder.entryBuilder().startLongField((class_2561)displayName, ((Long)backingProperty.getValue()).longValue()).setDefaultValue((Object)((Long)backingProperty.getDefaultValue()))).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (backingProperty.getType() == Float.class || backingProperty.getType() == Float.TYPE) {
                        categoryInstance.addEntry((AbstractConfigListEntry)((FloatFieldBuilder)builder.entryBuilder().startFloatField((class_2561)displayName, ((Float)backingProperty.getValue()).floatValue()).setDefaultValue((Object)((Float)backingProperty.getDefaultValue()))).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (backingProperty.getType() == Double.class || backingProperty.getType() == Double.TYPE) {
                        categoryInstance.addEntry((AbstractConfigListEntry)((DoubleFieldBuilder)builder.entryBuilder().startDoubleField((class_2561)displayName, ((Double)backingProperty.getValue()).doubleValue()).setDefaultValue((Object)((Double)backingProperty.getDefaultValue()))).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (backingProperty.getType() == Boolean.class || backingProperty.getType() == Boolean.TYPE) {
                        categoryInstance.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)builder.entryBuilder().startBooleanToggle((class_2561)displayName, ((Boolean)backingProperty.getValue()).booleanValue()).setDefaultValue((Object)((Boolean)backingProperty.getDefaultValue()))).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (Enum.class.isAssignableFrom(backingProperty.getType())) {
                        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startEnumSelector((class_2561)displayName, backingProperty.getType(), (Enum)backingProperty.getValue()).setDefaultValue((Enum)backingProperty.getDefaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (List.class.isAssignableFrom(backingProperty.getType()) && backingProperty.getInnerType() == String.class) {
                        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startStrList((class_2561)displayName, (List)backingProperty.getValue()).setDefaultValue((List)backingProperty.getDefaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (List.class.isAssignableFrom(backingProperty.getType()) && backingProperty.getInnerType() == Integer.class) {
                        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startIntList((class_2561)displayName, (List)backingProperty.getValue()).setDefaultValue((List)backingProperty.getDefaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (List.class.isAssignableFrom(backingProperty.getType()) && backingProperty.getInnerType() == Long.class) {
                        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startLongList((class_2561)displayName, (List)backingProperty.getValue()).setDefaultValue((List)backingProperty.getDefaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (List.class.isAssignableFrom(backingProperty.getType()) && backingProperty.getInnerType() == Float.class) {
                        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startFloatList((class_2561)displayName, (List)backingProperty.getValue()).setDefaultValue((List)backingProperty.getDefaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (List.class.isAssignableFrom(backingProperty.getType()) && backingProperty.getInnerType() == Double.class) {
                        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startDoubleList((class_2561)displayName, (List)backingProperty.getValue()).setDefaultValue((List)backingProperty.getDefaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(value)).build());
                        continue;
                    }
                    if (Set.class.isAssignableFrom(backingProperty.getType()) && backingProperty.getInnerType() == String.class) {
                        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startStrList((class_2561)displayName, new ArrayList((Set)backingProperty.getValue())).setDefaultValue(new ArrayList((Set)backingProperty.getDefaultValue())).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(new HashSet(value))).build());
                        continue;
                    }
                    if (Set.class.isAssignableFrom(backingProperty.getType()) && backingProperty.getInnerType() == Integer.class) {
                        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startIntList((class_2561)displayName, new ArrayList((Set)backingProperty.getValue())).setDefaultValue(new ArrayList((Set)backingProperty.getDefaultValue())).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(new HashSet(value))).build());
                        continue;
                    }
                    if (Set.class.isAssignableFrom(backingProperty.getType()) && backingProperty.getInnerType() == Long.class) {
                        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startLongList((class_2561)displayName, new ArrayList((Set)backingProperty.getValue())).setDefaultValue(new ArrayList((Set)backingProperty.getDefaultValue())).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(new HashSet(value))).build());
                        continue;
                    }
                    if (Set.class.isAssignableFrom(backingProperty.getType()) && backingProperty.getInnerType() == Float.class) {
                        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startFloatList((class_2561)displayName, new ArrayList((Set)backingProperty.getValue())).setDefaultValue(new ArrayList((Set)backingProperty.getDefaultValue())).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(new HashSet(value))).build());
                        continue;
                    }
                    if (!Set.class.isAssignableFrom(backingProperty.getType()) || backingProperty.getInnerType() != Double.class) continue;
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startDoubleList((class_2561)displayName, new ArrayList((Set)backingProperty.getValue())).setDefaultValue(new ArrayList((Set)backingProperty.getDefaultValue())).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> backingProperty.setValue(new HashSet(value))).build());
                }
            }
            return builder.build();
        };
    }
}

