/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.network;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.config.Synced;
import net.minecraft.class_2960;

public class ConfigReflection {
    public static List<Field> getAllFields(Class<?> clazz) {
        return Arrays.stream(clazz.getFields()).filter(it -> !Modifier.isFinal(it.getModifiers())).toList();
    }

    public static List<Field> getSyncedFields(Class<?> clazz) {
        Field[] fields;
        ArrayList<Field> syncedFields = new ArrayList<Field>();
        for (Field field : fields = clazz.getFields()) {
            if (!ConfigReflection.isSyncedFieldOrObject(field)) continue;
            syncedFields.add(field);
        }
        return syncedFields;
    }

    public static boolean isSyncedFieldOrObject(Field field) {
        boolean hasSyncedAnnotation = field.getAnnotation(Synced.class) != null;
        boolean isObject = !field.getType().isPrimitive() && !field.getType().isEnum() && field.getType() != String.class && field.getType() != List.class && field.getType() != Set.class && field.getType() != class_2960.class;
        return hasSyncedAnnotation || isObject;
    }

    public static Object deepCopy(Object from, Object to) {
        Field[] fields;
        for (Field field : fields = from.getClass().getFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            Class<?> type = field.getType();
            try {
                if (String.class.isAssignableFrom(type) || class_2960.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type) || type.isPrimitive()) {
                    field.set(to, field.get(from));
                    continue;
                }
                if (List.class.isAssignableFrom(type)) {
                    field.set(to, new ArrayList((Collection)field.get(from)));
                    continue;
                }
                if (Set.class.isAssignableFrom(type)) {
                    field.set(to, new HashSet((Collection)field.get(from)));
                    continue;
                }
                field.set(to, ConfigReflection.deepCopy(field.get(from), field.get(to)));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return to;
    }
}

