/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.foglooksgoodnow.config.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.Color;
import java.lang.reflect.Type;

public class ColorAdapter
implements JsonSerializer<Color>,
JsonDeserializer<Color> {
    public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            String hexColor = json.getAsString().toLowerCase().replace("#", "");
            return ColorAdapter.fromHex(hexColor);
        }
        catch (Exception e) {
            throw new JsonParseException("Invalid color: " + json.getAsString());
        }
    }

    public static Color fromHex(String hexColor) {
        try {
            hexColor = hexColor.toLowerCase().replace("#", "");
            return new Color(Integer.valueOf(hexColor.substring(0, 2), 16), Integer.valueOf(hexColor.substring(2, 4), 16), Integer.valueOf(hexColor.substring(4, 6), 16), Integer.valueOf(hexColor.substring(6, 8), 16));
        }
        catch (Exception e) {
            throw new JsonParseException("Invalid color: " + hexColor);
        }
    }

    public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(String.format("#%02x%02x%02x%02x", src.getRed(), src.getGreen(), src.getBlue(), src.getAlpha()).toUpperCase());
    }
}

